/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core.operations;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IPackageConfiguration;
import org.eclipse.stp.soas.deploy.core.IPackageConstructorExtension;
import org.eclipse.stp.soas.deploy.core.IPackageCreationContext;
import org.eclipse.stp.soas.deploy.core.IServiceDescriptor;
import org.eclipse.stp.soas.internal.deploy.core.PackageCreationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public class CreatePackageJob
extends Job {
    private IServiceDescriptor mPackage;
    private IPackageConstructorExtension mConstructor;
    private IPackageCreationContext mContext;
    private IPackageConfiguration mConfiguration;

    public CreatePackageJob(IServiceDescriptor pkg, IPackageConstructorExtension constructor, IPackageConfiguration configuration) {
        super(DeployCorePlugin.getDefault().getResourceString("CreatePackageJob.task.name"));
        this.mPackage = pkg;
        this.mConstructor = constructor;
        this.mConfiguration = configuration;
        this.setRule((ISchedulingRule)this.mPackage.getFile().getWorkspace().getRoot());
        this.setUser(true);
        this.setSystem(false);
    }

    public CreatePackageJob(IServiceDescriptor pkg, IPackageConstructorExtension constructor) {
        this(pkg, constructor, null);
    }

    public IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        monitor.beginTask(DeployCorePlugin.getDefault().getResourceString("CreatePackageJob.task.name"), 1000);
        try {
            this.buildWorkspace(monitor);
            this.checkCancelled(monitor);
            this.checkForErrors(monitor);
            this.checkCancelled(monitor);
            this.createPackage(monitor);
            this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
            this.setProperty(IProgressConstants.ACTION_PROPERTY, new Action(DeployCorePlugin.getDefault().getResourceString("CreatePackageJob.action.name")){

                public void run() {
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    display.syncExec(new Runnable(){

                        public void run() {
                            Shell shell;
                            boolean disposeShell = false;
                            Display display = Display.getCurrent();
                            Shell[] shells = display.getShells();
                            if (shells.length > 0) {
                                shell = shells[shells.length - 1];
                            } else {
                                disposeShell = true;
                                shell = new Shell();
                            }
                            try {
                                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)DeployCorePlugin.getDefault().getResourceString("CreatePackageFileAction.title.success"), (String)DeployCorePlugin.getDefault().getResourceString("CreatePackageFileAction.message.success", new Object[]{CreatePackageJob.this.mPackage.getFile().getFullPath().toString()}));
                            }
                            finally {
                                if (disposeShell) {
                                    shell.dispose();
                                }
                            }
                        }
                    });
                }
            });
        }
        catch (CoreException e) {
            status = e.getStatus();
        }
        catch (InterruptedException e) {
            status = Status.CANCEL_STATUS;
        }
        monitor.done();
        return status;
    }

    private void buildWorkspace(IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor buildMonitor = new SubProgressMonitor(monitor, 400);
        monitor.subTask(DeployCorePlugin.getDefault().getResourceString("CreatePackageJob.subtask.build"));
        this.mPackage.getFile().getWorkspace().build(10, (IProgressMonitor)buildMonitor);
        buildMonitor.done();
    }

    private void checkForErrors(IProgressMonitor monitor) throws CoreException {
        monitor.subTask(DeployCorePlugin.getDefault().getResourceString("CreatePackageJob.subtask.errorCheck"));
        IStatus[] validateStatus = this.mConstructor.validatePackage(this.mPackage, this.mConfiguration, null);
        if (validateStatus != null && validateStatus.length > 0) {
            MultiStatus status = new MultiStatus(DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, validateStatus, DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.message.log.buildPackage"), null);
            if (status.getSeverity() == 4) {
                throw new CoreException((IStatus)status);
            }
            status.getSeverity();
        }
        monitor.worked(100);
    }

    private void createPackage(IProgressMonitor monitor) throws CoreException {
        monitor.subTask(DeployCorePlugin.getDefault().getResourceString("CreatePackageJob.subtask.createPackage"));
        this.mContext = new PackageCreationContext(null, DeploymentExtensionManager.getInstance().getOutputFolder(this.mPackage, this.mConstructor.getName()).getLocation().toFile(), this.createTempFolder());
        if (!this.mContext.getOutputFolder().exists()) {
            this.mContext.getOutputFolder().mkdirs();
        }
        this.mConstructor.createPackage(this.mPackage, this.mContext, this.mConfiguration);
        this.deleteFile(this.mContext.getTempFolder());
        monitor.worked(500);
    }

    private void checkCancelled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private File createTempFolder() throws CoreException {
        try {
            File tmpFile = File.createTempFile("deploy_temp", ".tmp");
            File tempFolder = new File(tmpFile.getParentFile(), tmpFile.getName().substring(0, tmpFile.getName().lastIndexOf(".tmp")));
            tempFolder.mkdir();
            tmpFile.deleteOnExit();
            tempFolder.deleteOnExit();
            return tempFolder;
        }
        catch (IOException e) {
            Status status = new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("CreatePackageJob.error.tempDir"), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void deleteFile(File file) {
        File[] files = file.listFiles();
        if (files != null && files.length > 0) {
            int index = 0;
            int count = files.length;
            while (index < count) {
                this.deleteFile(files[index]);
                ++index;
            }
        }
        file.delete();
    }
}

