/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core.operations;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.core.operations.CreateDeployPackagesJob;
import org.eclipse.stp.soas.deploy.core.utils.DeploymentUtil;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.DeployStatusDialogPage;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.Dialog;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.IDialogPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.wst.server.core.IServer;

public class ExecuteDeploymentJob
extends Job {
    private Root mRoot;
    protected Map mDeployConfigToDeployTargetMap = new HashMap();
    private Map mDeployStatusMap = new HashMap();
    private boolean mHasErrorStatus = false;
    private CreateDeployPackagesJob mCreatePackages;
    private Shell mShell;

    public ExecuteDeploymentJob(Root root, Shell shell) {
        super(DeployCorePlugin.getDefault().getResourceString("ExecuteDeploymentJob.task.name"));
        this.mRoot = root;
        this.mShell = shell;
        this.mCreatePackages = new CreateDeployPackagesJob(this.mRoot);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        this.setUser(true);
        this.setSystem(false);
    }

    public IStatus run(IProgressMonitor monitor) {
        IStatus status;
        block8: {
            monitor.beginTask(DeployCorePlugin.getDefault().getResourceString("ExecuteDeploymentJob.task.name"), 3000);
            this.mDeployStatusMap.clear();
            this.mHasErrorStatus = false;
            status = Status.OK_STATUS;
            try {
                Map packageDescriptors = this.createPackages(monitor);
                this.preDeployCheck(packageDescriptors, monitor);
                this.deployPackages(packageDescriptors, monitor);
                if (this.mHasErrorStatus) {
                    status = new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("ExecuteDeploymentJob.error.job"), null);
                }
            }
            catch (CoreException e) {
                status = e.getStatus();
                this.mDeployConfigToDeployTargetMap.clear();
                break block8;
            }
            catch (InterruptedException e) {
                try {
                    status = Status.CANCEL_STATUS;
                    break block8;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.mDeployConfigToDeployTargetMap.clear();
                }
            }
            this.mDeployConfigToDeployTargetMap.clear();
        }
        this.logStatus();
        monitor.done();
        this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
        this.setProperty(IProgressConstants.ACTION_PROPERTY, new Action(DeployCorePlugin.getDefault().getResourceString("ExecuteDeploymentJob.action.name")){

            public void run() {
                ExecuteDeploymentJob.this.displayStatus();
            }
        });
        return status;
    }

    public Map getDeployStatusMap() {
        return this.mDeployStatusMap;
    }

    private void checkCancelled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    protected Map createPackages(IProgressMonitor monitor) throws CoreException, InterruptedException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1000);
        IStatus status = this.mCreatePackages.run((IProgressMonitor)subMonitor);
        if (status.getSeverity() != 0) {
            throw new CoreException(status);
        }
        this.checkCancelled(monitor);
        return this.mCreatePackages.getPackageDescriptors();
    }

    protected void preDeployCheck(Map packageDescriptors, IProgressMonitor monitor) throws CoreException, InterruptedException {
        int deployTaskLength = this.getDeployTaskLength();
        HashMap deployCheckStatus = new HashMap();
        boolean severity = false;
        for (Map.Entry entry : packageDescriptors.entrySet()) {
            DeployConfiguration config = (DeployConfiguration)entry.getKey();
            List descriptors = (List)entry.getValue();
            ArrayList<IPackageOutputDescriptor> exists = new ArrayList<IPackageOutputDescriptor>();
            for (IPackageOutputDescriptor descriptor : descriptors) {
                Status status;
                monitor.subTask(DeployCorePlugin.getDefault().getResourceString("ExecuteDeploymentJob.subtask.preDeployCheck", new Object[]{config.getSourcePackage().getPackageFile(), config.getTargetServer().getProfileName()}));
                if (descriptor == null) {
                    String exceptionMessage = DeployCorePlugin.getDefault().getResourceString("ExecuteDeploymentJob.error.deployError", new Object[]{config.getSourcePackage().getPackageFile(), config.getTargetServer().getProfileName()});
                    status = new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("ExecuteDeploymentJob.error.log.message"), (Throwable)new Exception(exceptionMessage));
                    throw new CoreException((IStatus)new MultiStatus(DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, new IStatus[]{status}, DeployCorePlugin.getDefault().getResourceString("DeployStatusDialog.TITLE"), null));
                }
                IServer server = Utilities.adaptToIServer((EObject)config);
                if (!DeploymentUtil.containsWTPModule(descriptor, config.getTargetServer().getServerId())) {
                    this.mDeployConfigToDeployTargetMap.put(config, server);
                    continue;
                }
                exists.add(descriptor);
                status = new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, "The application " + descriptor.getLogicalName() + " already exists on the server " + server.getName(), null);
                this.mDeployStatusMap.put(config, new Status[]{status});
            }
            descriptors.removeAll(exists);
            monitor.worked(deployTaskLength);
            this.checkCancelled(monitor);
        }
        this.checkCancelled(monitor);
    }

    private void deployPackages(Map packageDescriptors, IProgressMonitor monitor) throws CoreException, InterruptedException {
        int deployTaskLength = this.getDeployTaskLength();
        for (Map.Entry entry : packageDescriptors.entrySet()) {
            DeployConfiguration config = (DeployConfiguration)entry.getKey();
            List descriptors = (List)entry.getValue();
            for (IPackageOutputDescriptor descriptor : descriptors) {
                monitor.subTask(DeployCorePlugin.getDefault().getResourceString("ExecuteDeploymentJob.subtask.deploy", new Object[]{descriptor.getFileName(), config.getTargetServer().getProfileName()}));
                if (descriptor == null || !new File(descriptor.getFileName()).exists()) {
                    this.mDeployStatusMap.put(config, new IStatus[]{new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("Deploy.ERROR.PackageDoesNotExist", new Object[]{descriptor.getFileName(), config.getTargetServer().getProfileName()}), null)});
                    this.mHasErrorStatus = true;
                    continue;
                }
                IServer target = (IServer)this.mDeployConfigToDeployTargetMap.get(config);
                if (target == null) continue;
                IPackage ip = Utilities.adaptToIPackage((EObject)config);
                try {
                    DeploymentUtil.deployWTPModule(descriptor, target.getId(), ip.getFile().getProject());
                    this.mDeployStatusMap.put(config, new IStatus[]{new Status(1, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("Deploy.SUCCESS.Generic", new Object[]{descriptor.getFileName(), config.getTargetServer().getProfileName()}), null)});
                }
                catch (Exception e) {
                    this.mDeployStatusMap.put(config, new IStatus[]{new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("Deploy.ERROR.Generic", new Object[]{descriptor.getFileName(), target.getName(), e.getMessage()}), (Throwable)e)});
                    this.mHasErrorStatus = true;
                }
            }
            monitor.worked(deployTaskLength);
            this.checkCancelled(monitor);
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        final DeployStatusDialogPage page = new DeployStatusDialogPage(this.mDeployStatusMap, DeployCorePlugin.getDefault().getResourceString("DeployStatusDialog.TITLE"));
        display.syncExec(new Runnable(){

            public void run() {
                boolean disposeShell = false;
                Display display = Display.getCurrent();
                Shell shell = display.getActiveShell();
                if (shell == null) {
                    Shell[] shells = display.getShells();
                    if (shells.length > 0) {
                        shell = shells[shells.length - 1];
                    } else {
                        disposeShell = true;
                        shell = new Shell();
                    }
                }
                try {
                    Dialog dialog = new Dialog(shell, (IDialogPage)page, 16);
                    dialog.open();
                }
                finally {
                    if (disposeShell) {
                        shell.dispose();
                    }
                }
            }
        });
        this.checkCancelled(monitor);
    }

    private int getDeployTaskLength() {
        int retVal = 0;
        Iterator it = this.mRoot.getPackage().iterator();
        while (it.hasNext()) {
            retVal += ((DeployPackage)it.next()).getTargetConfiguration().size();
        }
        return retVal / 1000 + 1;
    }

    private int getRefreshTaskLength() {
        return this.mRoot.getServer().size() / 1000 + 1;
    }

    private void logStatus() {
        ArrayList statuses = new ArrayList();
        Iterator it = this.mDeployStatusMap.values().iterator();
        while (it.hasNext()) {
            statuses.addAll(Arrays.asList((IStatus[])it.next()));
        }
        DeployCorePlugin.getDefault().log((IStatus)new MultiStatus(DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, statuses.toArray(new IStatus[statuses.size()]), DeployCorePlugin.getDefault().getResourceString("DeployStatusDialog.TITLE"), null));
    }

    private void displayStatus() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        final DeployStatusDialogPage page = new DeployStatusDialogPage(this.mDeployStatusMap, DeployCorePlugin.getDefault().getResourceString("DeployStatusDialog.TITLE"));
        display.syncExec(new Runnable(){

            public void run() {
                boolean disposeShell = false;
                Display display = Display.getCurrent();
                Shell shell = ExecuteDeploymentJob.this.mShell;
                if (shell == null) {
                    Shell[] shells = display.getShells();
                    if (shells.length > 0) {
                        shell = shells[shells.length - 1];
                    } else {
                        disposeShell = true;
                        shell = new Shell();
                    }
                }
                try {
                    Dialog dialog = new Dialog(shell, (IDialogPage)page, 16);
                    dialog.open();
                }
                finally {
                    if (disposeShell) {
                        shell.dispose();
                    }
                }
            }
        });
    }
}

