/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IDeployTarget;
import org.eclipse.stp.soas.deploy.core.IPackageConfiguration;
import org.eclipse.stp.soas.deploy.core.IPackageConstructor;
import org.eclipse.stp.soas.deploy.core.IPackageConstructorExtension;
import org.eclipse.stp.soas.deploy.core.IPackageCreationContext;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.IPackageValidator;
import org.eclipse.stp.soas.deploy.core.IRuntimeDefinition;
import org.eclipse.stp.soas.deploy.core.IRuntimeType;
import org.eclipse.stp.soas.deploy.core.IServerType;
import org.eclipse.stp.soas.deploy.core.IServiceDescriptor;
import org.eclipse.stp.soas.deploy.core.ISupportValidator;
import org.eclipse.stp.soas.deploy.core.ISupportedRuntimeType;
import org.eclipse.stp.soas.deploy.core.ISupportedServerType;
import org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType;
import org.eclipse.stp.soas.deploy.core.ITechnologyType;
import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.deploy.core.MatchRule;
import org.eclipse.stp.soas.deploy.core.ServerType;
import org.eclipse.stp.soas.deploy.core.Version;
import org.eclipse.stp.soas.deploy.core.utils.DeploymentUtil;
import org.eclipse.stp.soas.internal.deploy.core.DeployTarget;
import org.eclipse.stp.soas.internal.deploy.core.PackageExtensionException;
import org.eclipse.stp.soas.internal.deploy.core.SupportedRuntimeType;
import org.eclipse.stp.soas.internal.deploy.core.SupportedServerType;
import org.eclipse.stp.soas.internal.deploy.core.SupportedTechnologyType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageConstructorExtension
implements IPackageConstructorExtension {
    public static final String ATTR_ID = "id";
    public static final String ATTR_PROFILE = "profile";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_NAME = "label";
    public static final String ELEM_SERVER = "supportedServer";
    public static final String ELEM_PACKAGE_CONSTRUCTOR = "packageConstructor";
    public static final String ELEM_SUPPORTED_TECHNOLOGY = "supportedTechnology";
    public static final String ELEM_SUPPORTED_SERVER = "supportedServer";
    public static final String ELEM_SUPPORTED_RUNTIME = "supportedRuntime";
    public static final String ATTR_SUPPORT_VALIDATOR = "supportValidator";
    public static final String ATTR_PACKAGE_VALIDATOR = "packageValidator";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_MIN_VERSION = "minVersion";
    public static final String ATTR_MAX_VERSION = "maxVersion";
    public static final String ATTR_MATCH_RULE = "matchRule";
    private IConfigurationElement mElement;
    private String mID;
    private String mName;
    private IPackageConstructor mConstructor;
    private ISupportValidator mSupportValidator;
    private IPackageValidator mPackageValidator;
    private ISupportedTechnologyType mSupportedTechnology;
    private List<ISupportedServerType> mSupportedServers;
    private List<ISupportedRuntimeType> mSupportedRuntime;

    public PackageConstructorExtension(IConfigurationElement element) throws PackageExtensionException {
        this.init(element);
    }

    public IConfigurationElement getConfigurationElement() {
        return this.mElement;
    }

    @Override
    public String getID() {
        return this.mID;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public List<IPackageOutputDescriptor> createPackage(IServiceDescriptor pkg, IPackageCreationContext context, IPackageConfiguration configuration) throws CoreException {
        this.initConstructor();
        if (this.mConstructor == null) {
            Status status = new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.error.couldNotLoadPackageConstructor"), null);
            throw new CoreException((IStatus)status);
        }
        List<IPackageOutputDescriptor> retVal = this.mConstructor.createPackage(pkg, context, configuration);
        return retVal;
    }

    @Override
    public boolean supportsPackage(IServiceDescriptor pkg) {
        boolean retVal = this.getSupportedTechnologyType().supportsTechnology(pkg.getTechnologyType());
        if (pkg.getRuntimeType() != null && !this.supportsRuntimeType(pkg.getRuntimeType())) {
            retVal = false;
        }
        if (retVal) {
            this.initSupportValidator();
            if (this.mSupportValidator != null) {
                retVal = retVal && this.mSupportValidator.supportsFile(pkg.getFile());
            }
        }
        return retVal;
    }

    @Override
    public boolean supportsServer(IServerType serverType) {
        List<ISupportedServerType> serverTypes = this.getSupportedServerType();
        for (ISupportedServerType isst : serverTypes) {
            if (!isst.supportsServer(serverType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsRuntimeType(IRuntimeType type) {
        for (ISupportedRuntimeType isrt : this.getSupportedRuntimeType()) {
            if (!isrt.supportsRuntime(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsTechnology(ITechnologyType type) {
        return false;
    }

    @Override
    public IStatus[] validatePackage(IServiceDescriptor pkg, IPackageConfiguration configuration, IDeployTarget target) {
        this.initPackageValidator();
        IStatus[] retVal = this.mPackageValidator == null ? new IStatus[]{} : this.mPackageValidator.validate(pkg, configuration, target);
        return retVal;
    }

    @Override
    public ISupportedTechnologyType getSupportedTechnologyType() {
        return this.mSupportedTechnology;
    }

    @Override
    public List<ISupportedRuntimeType> getSupportedRuntimeType() {
        return this.mSupportedRuntime;
    }

    @Override
    public List<ISupportedServerType> getSupportedServerType() {
        return this.mSupportedServers;
    }

    private void init(IConfigurationElement element) throws PackageExtensionException {
        this.mElement = element;
        this.mID = element.getAttribute(ATTR_ID);
        this.mName = element.getAttribute(ATTR_NAME);
        if (this.mSupportedServers == null) {
            this.mSupportedServers = new ArrayList<ISupportedServerType>();
        }
        if (this.mSupportedRuntime == null) {
            this.mSupportedRuntime = new ArrayList<ISupportedRuntimeType>();
        }
        this.processTechnology(element);
        this.processServers(element);
        this.processRuntime(element);
    }

    private void processTechnology(IConfigurationElement element) throws PackageExtensionException {
        IConfigurationElement[] supportedTechnologies = element.getChildren(ELEM_SUPPORTED_TECHNOLOGY);
        if (supportedTechnologies.length < 1) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.trace.error.supportedTechnologyNotSpecified", new Object[]{this.mID}));
                System.err.flush();
            }
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.exception.supportedTechnologyNotSpecified"));
        }
        if (supportedTechnologies.length > 1) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.trace.error.multipleSupportedTechnologyElements", new Object[]{this.mID}));
                System.err.flush();
            }
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.exception.multipleSupportedTechnologyElements"));
        }
        this.mSupportedTechnology = new SupportedTechnologyType(supportedTechnologies[0]);
    }

    private void processServers(IConfigurationElement element) throws PackageExtensionException {
        IConfigurationElement[] supportedServers = element.getChildren("supportedServer");
        int cfr_ignored_0 = supportedServers.length;
        int i = 0;
        while (i < supportedServers.length) {
            block3: {
                try {
                    this.mSupportedServers.add(new SupportedServerType(supportedServers[i]));
                }
                catch (PackageExtensionException e) {
                    if (this.mSupportedServers.size() != 0) break block3;
                    throw e;
                }
            }
            ++i;
        }
    }

    private void processRuntime(IConfigurationElement element) throws PackageExtensionException {
        IConfigurationElement[] supportedRuntimes = element.getChildren(ELEM_SUPPORTED_RUNTIME);
        if (supportedRuntimes.length < 1) {
            return;
        }
        if (supportedRuntimes.length > 1) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.trace.error.multipleSupportedRuntimeElements", new Object[]{this.mID}));
                System.err.flush();
            }
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.exception.multipleSupportedRuntimeElements"));
        }
        this.initSupportedRuntime(supportedRuntimes[0]);
    }

    private void initSupportedRuntime(IConfigurationElement rtElement) {
        String mRuntimeDef = rtElement.getAttribute(ATTR_TYPE);
        Version mMinVersion = Version.valueOf(rtElement.getAttribute(ATTR_MIN_VERSION));
        Version mMaxVersion = Version.valueOf(rtElement.getAttribute(ATTR_MAX_VERSION));
        String matchRule = rtElement.getAttribute(ATTR_MATCH_RULE);
        MatchRule mr = matchRule != null && !"".equals(matchRule) ? MatchRule.valueOf(rtElement.getAttribute(ATTR_MATCH_RULE)) : null;
        List<IRuntimeDefinition> irds = DeploymentExtensionManager.getInstance().getRuntimeDefinitionByType(mRuntimeDef);
        for (IRuntimeDefinition ird : irds) {
            String runId = ird.getID();
            IVersion runVersion = DeploymentUtil.getSTPVersionByWTPRuntimeType(ServerCore.findRuntimeType((String)runId));
            if (runVersion.compareTo(mMinVersion) < 0 || runVersion.compareTo(mMaxVersion) > 0) continue;
            this.mSupportedRuntime.add(new SupportedRuntimeType(runId, mMinVersion, mMaxVersion, mr));
        }
    }

    private void initConstructor() {
        block3: {
            if (this.mConstructor == null) {
                try {
                    this.mConstructor = (IPackageConstructor)this.mElement.createExecutableExtension(ATTR_CLASS);
                }
                catch (CoreException e) {
                    if (!DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) break block3;
                    System.err.println(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.trace.error.couldNotLoadPackageConstructor", new Object[]{this.getID(), this.mElement.getAttribute(ATTR_CLASS)}));
                    System.err.flush();
                }
            }
        }
    }

    private void initSupportValidator() {
        block3: {
            if (this.mSupportValidator == null) {
                try {
                    this.mSupportValidator = (ISupportValidator)this.mElement.createExecutableExtension(ATTR_SUPPORT_VALIDATOR);
                }
                catch (CoreException e) {
                    if (!DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) break block3;
                    System.err.println(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.trace.error.couldNotLoadSupportValidator", new Object[]{this.getID(), this.mElement.getAttribute(ATTR_SUPPORT_VALIDATOR)}));
                    System.err.flush();
                }
            }
        }
    }

    private void initPackageValidator() {
        block3: {
            if (this.mPackageValidator == null) {
                try {
                    this.mPackageValidator = (IPackageValidator)this.mElement.createExecutableExtension(ATTR_PACKAGE_VALIDATOR);
                }
                catch (CoreException e) {
                    if (!DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) break block3;
                    System.err.println(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.trace.error.couldNotLoadPackageValidator", new Object[]{this.getID(), this.mElement.getAttribute(ATTR_SUPPORT_VALIDATOR)}));
                    System.err.flush();
                }
            }
        }
    }

    @Override
    public IDeployTarget adaptServer(IServer server) {
        String serverTypeId = server.getServerType().getId();
        ServerType serverType = new ServerType(serverTypeId, DeploymentUtil.getSTPVersionFromWTPServer(server));
        DeployTarget idt = this.supportsServer(serverType) ? new DeployTarget(this, server) : null;
        return idt;
    }
}

