/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.util.Assert;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackage;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackageExtension;
import org.eclipse.stp.soas.deploy.core.IServerType;
import org.eclipse.stp.soas.deploy.core.ISupportedServerType;
import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.internal.deploy.core.PackageExtension;
import org.eclipse.stp.soas.internal.deploy.core.PackageExtensionException;
import org.eclipse.stp.soas.internal.deploy.core.SupportedServerType;

public class PhysicalPackageExtension
extends PackageExtension
implements IPhysicalPackageExtension {
    public static final String ATTR_CLASS = "class";
    private ISupportedServerType mSupportedServer;

    public PhysicalPackageExtension(IConfigurationElement element) throws PackageExtensionException {
        super(element);
        this.init();
    }

    public IPackage adaptFile(IFile file) {
        IPhysicalPackage ipp;
        try {
            ipp = (IPhysicalPackage)this.getConfigurationElement().createExecutableExtension(ATTR_CLASS);
            ipp.init(this, file);
        }
        catch (CoreException e) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("PhysicalPackageExtension.trace.error.physicalPackageError", new Object[]{this.getID(), this.getConfigurationElement().getAttribute(ATTR_CLASS), file.getFullPath().toString()}));
                System.err.flush();
            }
            ipp = null;
        }
        return ipp;
    }

    public ISupportedServerType getSupportedServerType() {
        return this.mSupportedServer;
    }

    public boolean supportsServer(IServerType type) {
        IVersion typeVersion = type.getVersion();
        boolean retVal = type.getServerDefinition().equals(this.mSupportedServer.getServerDefinition()) && typeVersion.compareTo(this.mSupportedServer.getMinVersion()) >= 0 && (typeVersion.compareTo(this.mSupportedServer.getMaxVersion()) <= 0 || typeVersion.equals(this.mSupportedServer.getMaxVersion()));
        return retVal;
    }

    private void init() throws PackageExtensionException {
        Assert.isTrue((boolean)"physicalPackage".equals(this.getConfigurationElement().getName()));
        this.processSupportedServerElement();
    }

    private void processSupportedServerElement() throws PackageExtensionException {
        IConfigurationElement[] supportedServers = this.getConfigurationElement().getChildren("supportedServer");
        if (supportedServers.length < 1) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("PhysicalPackageExtension.trace.error.supportedServerNotSpecified", new Object[]{this.getID()}));
                System.err.flush();
            }
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("PhysicalPackageExtension.exception.supportedServerNotSpecified"));
        }
        if (supportedServers.length > 1) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("PhysicalPackageExtension.trace.error.multipleSupportedServerElements", new Object[]{this.getID()}));
                System.err.flush();
            }
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("PhysicalPackageExtension.exception.multipleSupportedServerElements"));
        }
        this.mSupportedServer = new SupportedServerType(supportedServers[0]);
    }
}

