/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.IServiceDescriptor;
import org.eclipse.stp.soas.deploy.core.IServiceDescriptorExtension;
import org.eclipse.stp.soas.deploy.core.ISupportedRuntimeType;
import org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType;
import org.eclipse.stp.soas.deploy.core.ITechnologyType;
import org.eclipse.stp.soas.internal.deploy.core.PackageExtension;
import org.eclipse.stp.soas.internal.deploy.core.PackageExtensionException;
import org.eclipse.stp.soas.internal.deploy.core.SupportedRuntimeType;
import org.eclipse.stp.soas.internal.deploy.core.SupportedTechnologyType;
import org.eclipse.wst.server.core.IRuntimeType;

public class ServiceDescriptorExtension
extends PackageExtension
implements IServiceDescriptorExtension {
    public static final String ATTR_CLASS = "class";
    private ISupportedTechnologyType mSupportedTechnology;
    private ISupportedRuntimeType mSupportedRuntime;

    public ServiceDescriptorExtension(IConfigurationElement element) throws PackageExtensionException {
        super(element);
        this.init();
    }

    public ISupportedTechnologyType getSupportedTechnologyType() {
        return this.mSupportedTechnology;
    }

    public boolean supportsTechnology(ITechnologyType type) {
        return this.mSupportedTechnology.supportsTechnology(type);
    }

    public IPackage adaptFile(IFile file) {
        IServiceDescriptor ilp;
        try {
            ilp = (IServiceDescriptor)this.getConfigurationElement().createExecutableExtension(ATTR_CLASS);
            ilp.init(this, file);
        }
        catch (CoreException e) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("LogicalPackageExtension.trace.error.logicalPackageClassNotFound", new Object[]{this.getID(), this.getConfigurationElement().getAttribute(ATTR_CLASS), file.getFullPath().toString()}));
                System.err.flush();
            }
            ilp = null;
        }
        return ilp;
    }

    private void init() throws PackageExtensionException {
        this.processSupportedTechnologyElement();
        this.processSupportedRuntimeElement();
    }

    private void processSupportedTechnologyElement() throws PackageExtensionException {
        IConfigurationElement[] supportedTechnologies = this.getConfigurationElement().getChildren("supportedTechnology");
        if (supportedTechnologies.length < 1) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("LogicalPackageExtension.trace.error.supportedTechnologyNotSpecified", new Object[]{this.getID()}));
                System.err.flush();
            }
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("LogicalPackageExtension.exception.supportedTechnologyNotSpecified"));
        }
        if (supportedTechnologies.length > 1) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("LogicalPackageExtension.trace.error.multipleSupportedTechnologyElements", new Object[]{this.getID()}));
                System.err.flush();
            }
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("LogicalPackageExtension.exception.multipleSupportedTechnologyElements"));
        }
        this.mSupportedTechnology = new SupportedTechnologyType(supportedTechnologies[0]);
    }

    private void processSupportedRuntimeElement() throws PackageExtensionException {
        IConfigurationElement[] supportedRuntimes = this.getConfigurationElement().getChildren("supportedRuntime");
        if (supportedRuntimes.length < 1) {
            return;
        }
        if (supportedRuntimes.length > 1) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("LogicalPackageExtension.trace.error.multipleSupportedTechnologyElements", new Object[]{this.getID()}));
                System.err.flush();
            }
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("LogicalPackageExtension.exception.multipleSupportedTechnologyElements"));
        }
        this.mSupportedRuntime = new SupportedRuntimeType(supportedRuntimes[0]);
    }

    public ISupportedRuntimeType getSupportedRuntimeType() {
        return this.mSupportedRuntime;
    }

    public boolean supportsRuntime(IRuntimeType type) {
        return false;
    }
}

