/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.soas.deploy.core.FilePackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module.ServiceModuleDelegate;
import org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module.StpModule;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Module;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.model.ModuleFactoryDelegate;

public class WTPServiceModuleFactory
extends ModuleFactoryDelegate {
    public static String FACET_PROJECT_NATURE = "org.eclipse.wst.common.project.facet.core.nature";
    public static String MODULE_TYPE = "jst.web";
    public static String MODULE_VERSION = "2.2";
    public static String MODULE_TYPE_JAXWS = "stp.jaxws.component";
    public static String MODULE_VERSION_JAXWS = "2.1";
    private List<IModule> moduleValues = new ArrayList<IModule>();
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WTPServiceModuleFactory.class);
    protected Map<IModule, ModuleDelegate> moduleDelegates = new HashMap<IModule, ModuleDelegate>(5);

    public ModuleDelegate getModuleDelegate(IModule module) {
        return this.moduleDelegates.get(module);
    }

    public IModule[] getModules() {
        this.moduleValues.clear();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isAccessible()) {
                this.getModulesByProject(projects[i]);
            }
            ++i;
        }
        return this.moduleValues.toArray(new IModule[this.moduleValues.size()]);
    }

    private void getModulesByProject(IProject project) {
        IFile[] wars = this.findWarFileByProject((IContainer)project);
        int i = 0;
        while (i < wars.length) {
            IModule modules2;
            File warFile = new File(wars[i].getLocation().toOSString());
            if (warFile.exists() && (modules2 = this.createModule(project, null, MODULE_TYPE_JAXWS, MODULE_VERSION_JAXWS, warFile)) != null) {
                this.moduleValues.add(modules2);
            }
            ++i;
        }
    }

    private IFile[] findWarFileByProject(IContainer container) {
        ArrayList<IFile> wars = new ArrayList<IFile>();
        try {
            IResource[] res = container.members();
            int i = 0;
            while (i < res.length) {
                if (res[i] instanceof IFile && res[i].getName().endsWith(".war")) {
                    wars.add((IFile)res[i]);
                } else if (res[i] instanceof IContainer) {
                    wars.addAll((Collection)Arrays.asList(this.findWarFileByProject((IContainer)res[i])));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return wars.toArray(new IFile[wars.size()]);
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private void addFacetNature(IProject project) throws Exception {
        IProjectDescription projDesc = project.getDescription();
        String[] natures = projDesc.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[newNatures.length - 1] = FACET_PROJECT_NATURE;
        projDesc.setNatureIds(newNatures);
        project.setDescription(projDesc, null);
    }

    public IModule createModule(IProject project, IPackageOutputDescriptor desc, File warFile) {
        return this.createModule(project, desc, MODULE_TYPE, MODULE_VERSION, warFile);
    }

    private IModule createModule(IProject project, IPackageOutputDescriptor desc, String moduleType, String version, File warFile) {
        try {
            if (!project.hasNature(FACET_PROJECT_NATURE)) {
                this.addFacetNature(project);
            }
            IProjectFacet pf = ProjectFacetsManager.getProjectFacet((String)MODULE_TYPE);
            IProjectFacetVersion fv = pf.getVersion(MODULE_VERSION);
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            if (!facetedProject.hasProjectFacet(pf)) {
                LOG.debug((Object)"install jst.web facet");
                facetedProject.installProjectFacet(fv, null, null);
            }
        }
        catch (CoreException pf) {
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error((Object)e);
        }
        IModule module = this.createStpModule(MODULE_TYPE, MODULE_VERSION, project, desc, warFile);
        ServiceModuleDelegate moduleDelegate = new ServiceModuleDelegate(project, desc);
        moduleDelegate.setModule(module);
        this.moduleDelegates.put(module, (ModuleDelegate)moduleDelegate);
        ((Module)module).validate(null);
        return module;
    }

    public String getModuleName(IPackageOutputDescriptor desc) {
        String name = desc.getLogicalName();
        if (desc instanceof FilePackageOutputDescriptor) {
            name = ((FilePackageOutputDescriptor)desc).getFile().getName();
        }
        if (name.endsWith(".war")) {
            name = name.substring(0, name.indexOf(".war"));
        }
        return name;
    }

    protected IModule createStpModule(String type, String version, IProject project, IPackageOutputDescriptor desc, File warFile) {
        String factorId = this.getId();
        ModuleFactory factory = ServerPlugin.findModuleFactory((String)factorId);
        String fileName = warFile.getName();
        if (fileName.endsWith(".war")) {
            fileName = fileName.substring(0, fileName.indexOf(".war"));
        }
        return new StpModule(factory, type, version, project, fileName, fileName, warFile);
    }
}

