/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui;

import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageDescriptorRegistry {
    private HashMap fRegistry = new HashMap(10);
    private Display fDisplay;

    public ImageDescriptorRegistry() {
        this(ImageDescriptorRegistry.getStandardDisplay());
    }

    public ImageDescriptorRegistry(Display display) {
        this.fDisplay = display;
        Assert.isNotNull((Object)this.fDisplay);
        this.hookDisplay();
    }

    public Image get(ImageDescriptor descriptor) {
        Image result;
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((result = (Image)this.fRegistry.get(descriptor)) != null) {
            return result;
        }
        Assert.isTrue((this.fDisplay == ImageDescriptorRegistry.getStandardDisplay() ? 1 : 0) != 0, (String)"Allocating image for wrong display.");
        result = descriptor.createImage();
        if (result != null) {
            this.fRegistry.put(descriptor, result);
        }
        return result;
    }

    public void dispose() {
        for (Image image : this.fRegistry.values()) {
            image.dispose();
        }
        this.fRegistry.clear();
    }

    private void hookDisplay() {
        this.fDisplay.disposeExec(new Runnable(){

            public void run() {
                ImageDescriptorRegistry.this.dispose();
            }
        });
    }

    private static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

