/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ProjectsFilter
extends ViewerFilter {
    private IProject mSourceProject;
    private List mAvailableProjects;
    private Comparator mProjectComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((IProject)o1).getFullPath().toString().compareTo(((IProject)o2).getFullPath().toString());
        }

        public boolean equals(Object obj) {
            return this.compare(this, obj) == 0;
        }
    };

    public ProjectsFilter(IProject sourceProject) {
        this.mSourceProject = sourceProject;
        this.updateAvailableProjects();
    }

    public boolean setSourceProject(IProject sourceProject) {
        boolean doUpdate = sourceProject == null ? this.mSourceProject != null : !sourceProject.equals((Object)this.mSourceProject);
        if (doUpdate) {
            this.mSourceProject = sourceProject;
            this.updateAvailableProjects();
        }
        return doUpdate;
    }

    private void updateAvailableProjects() {
        if (this.mSourceProject == null) {
            this.mAvailableProjects = new Vector(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
        } else {
            IProject[] projects;
            try {
                projects = this.mSourceProject.getReferencedProjects();
            }
            catch (CoreException e) {
                projects = new IProject[]{};
            }
            this.mAvailableProjects = new Vector(projects.length + 1);
            this.mAvailableProjects.add(this.mSourceProject);
            this.mAvailableProjects.addAll((Collection)Arrays.asList(projects));
        }
        Collections.sort(this.mAvailableProjects, this.mProjectComparator);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean retVal = element instanceof IProject ? Collections.binarySearch(this.mAvailableProjects, element, this.mProjectComparator) >= 0 : true;
        return retVal;
    }
}

