/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.stp.ui.xef.editor.Setting;
import org.eclipse.stp.ui.xef.schema.IContextProvider;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.IXMLProvider;
import org.eclipse.stp.xef.util.InputStreamHelper;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLProviderEditorInput
extends FileEditorInput {
    private static volatile int counter = 0;
    private final IXMLProvider provider;
    private final IProject project;
    private final ISchemaProvider schemaProvider;
    private final IContextProvider contextProvider;
    protected Map<Setting, String> settings;

    public XMLProviderEditorInput(String t, IProject prj, IXMLProvider p, ISchemaProvider sp, IContextProvider cp) throws IOException, CoreException {
        this(XMLProviderEditorInput.getTitleSettings(t), prj, p, sp, cp);
    }

    private static Map<Setting, String> getTitleSettings(String title) {
        EnumMap<Setting, String> m = new EnumMap<Setting, String>(Setting.class);
        m.put(Setting.TITLE, title);
        return m;
    }

    public XMLProviderEditorInput(Map<Setting, String> s, IProject prj, IXMLProvider p, ISchemaProvider sp, IContextProvider cp) throws IOException, CoreException {
        super(XMLProviderEditorInput.createTempFile(prj, p));
        this.settings = s;
        this.project = prj;
        this.provider = p;
        this.schemaProvider = sp;
        this.contextProvider = cp;
    }

    private static IFile createTempFile(IProject project, IXMLProvider provider) throws IOException, CoreException {
        IFolder tempFolder = project.getFolder(".xeftemp");
        if (!tempFolder.exists()) {
            tempFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        IFile tempfile = tempFolder.getFile(".xml.tmp" + System.currentTimeMillis() + "_" + counter++ + ".xml");
        tempfile.getLocation().toFile().deleteOnExit();
        tempfile.create((InputStream)new ByteArrayInputStream(provider.getXML().getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
        tempFolder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        return tempfile;
    }

    public IContextProvider getContextProvider() {
        return this.contextProvider;
    }

    public IProject getProject() {
        return this.project;
    }

    public ISchemaProvider getSchemaProvider() {
        return this.schemaProvider;
    }

    public IXMLProvider getXMLProvider() {
        return this.provider;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getSetting(Setting key) {
        String o = this.settings.get((Object)key);
        if (o == null) {
            o = key.getDefault();
        }
        return o;
    }

    public void propagate() throws IOException, CoreException {
        InputStream is = this.getFile().getContents();
        try {
            this.provider.setXML(new String(InputStreamHelper.drain((InputStream)is)));
            this.getFile().refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            is.close();
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof XMLProviderEditorInput) {
            XMLProviderEditorInput otherInput = (XMLProviderEditorInput)((Object)other);
            return this.getXMLProvider().equals(otherInput.getXMLProvider());
        }
        return false;
    }
}

