/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.config;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.osgi.util.internal.ReflectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

abstract class CustomListenerAdapterUtils {
    private static final Log log = LogFactory.getLog((Class)CustomListenerAdapterUtils.class);

    CustomListenerAdapterUtils() {
    }

    static Map determineCustomMethods(final Class target, final String methodName, final Class[] possibleArgumentTypes) {
        if (!StringUtils.hasText((String)methodName)) {
            return Collections.EMPTY_MAP;
        }
        Assert.notEmpty((Object[])possibleArgumentTypes);
        final LinkedHashMap methods = new LinkedHashMap(3);
        final boolean trace = log.isTraceEnabled();
        org.springframework.util.ReflectionUtils.doWithMethods((Class)target, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Class<?>[] args;
                if (methodName.equals(method.getName()) && (args = method.getParameterTypes()) != null && args.length == 2) {
                    Class<?> propType = args[1];
                    for (int i = 0; i < possibleArgumentTypes.length; ++i) {
                        Method m;
                        Class clazz = possibleArgumentTypes[i];
                        if (!clazz.isAssignableFrom(propType)) continue;
                        if (trace) {
                            log.trace((Object)("discovered custom method [" + method.toString() + "] on " + target));
                        }
                        if ((m = (Method)methods.get(args[0])) != null) {
                            if (!trace) continue;
                            log.trace((Object)("type " + args[0] + " already has an associated method [" + m.toString() + "];ignoring " + method));
                            continue;
                        }
                        org.springframework.util.ReflectionUtils.makeAccessible((Method)method);
                        methods.put(args[0], method);
                    }
                }
            }
        });
        return methods;
    }

    static Map determineCustomMethods(Class target, String methodName) {
        return CustomListenerAdapterUtils.determineCustomMethods(target, methodName, new Class[]{Dictionary.class, Map.class});
    }

    static void invokeCustomMethods(Object target, Map methods, Object service, Map properties) {
        if (methods != null && !methods.isEmpty()) {
            boolean trace = log.isTraceEnabled();
            Object[] args = new Object[]{service, properties};
            Iterator iter = methods.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Class key = (Class)entry.getKey();
                Method method = (Method)entry.getValue();
                if (service != null && !key.isInstance(service)) continue;
                if (trace) {
                    log.trace((Object)("invoking listener custom method " + method));
                }
                try {
                    ReflectionUtils.invokeMethod(method, target, args);
                }
                catch (Exception ex) {
                    Exception cause = ReflectionUtils.getInvocationException(ex);
                    log.warn((Object)("custom method [" + method + "] threw exception when passing service type [" + (service != null ? service.getClass().getName() : null) + "]"), (Throwable)cause);
                }
            }
        }
    }
}

