/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.context.support;

import java.io.IOException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import org.springframework.beans.factory.xml.DelegatingEntityResolver;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.osgi.context.support.AbstractDelegatedExecutionApplicationContext;
import org.springframework.osgi.context.support.DelegatedEntityResolver;
import org.springframework.osgi.context.support.DelegatedNamespaceHandlerResolver;
import org.springframework.osgi.context.support.TrackingUtil;
import org.springframework.osgi.util.OsgiStringUtils;
import org.xml.sax.EntityResolver;

public class OsgiBundleXmlApplicationContext
extends AbstractDelegatedExecutionApplicationContext {
    public static final String DEFAULT_CONFIG_LOCATION = "osgibundle:/META-INF/spring/*.xml";

    public OsgiBundleXmlApplicationContext() {
        this((String[])null);
    }

    public OsgiBundleXmlApplicationContext(ApplicationContext parent) {
        this(null, parent);
    }

    public OsgiBundleXmlApplicationContext(String[] configLocations) {
        this(configLocations, null);
    }

    public OsgiBundleXmlApplicationContext(String[] configLocations, ApplicationContext parent) {
        super(parent);
        this.setConfigLocations(configLocations);
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        XmlBeanDefinitionReader beanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        beanDefinitionReader.setResourceLoader((ResourceLoader)this);
        NamespaceHandlerResolver nsResolver = this.createNamespaceHandlerResolver();
        EntityResolver enResolver = this.createEntityResolver();
        beanDefinitionReader.setEntityResolver(enResolver);
        beanDefinitionReader.setNamespaceHandlerResolver(nsResolver);
        this.initBeanDefinitionReader(beanDefinitionReader);
        this.loadBeanDefinitions(beanDefinitionReader);
    }

    private NamespaceHandlerResolver createNamespaceHandlerResolver() {
        DefaultNamespaceHandlerResolver localNamespaceResolver = new DefaultNamespaceHandlerResolver(this.getClassLoader());
        NamespaceHandlerResolver osgiServiceNamespaceResolver = this.lookupNamespaceHandlerResolver(localNamespaceResolver);
        DelegatedNamespaceHandlerResolver delegate = new DelegatedNamespaceHandlerResolver();
        delegate.addNamespaceHandler((NamespaceHandlerResolver)localNamespaceResolver, "LocalNamespaceResolver for bundle " + OsgiStringUtils.nullSafeNameAndSymName(this.getBundle()));
        delegate.addNamespaceHandler(osgiServiceNamespaceResolver, "OSGi Service resolver");
        return delegate;
    }

    private EntityResolver createEntityResolver() {
        DelegatingEntityResolver localEntityResolver = new DelegatingEntityResolver(this.getClassLoader());
        EntityResolver osgiServiceEntityResolver = this.lookupEntityResolver(localEntityResolver);
        DelegatedEntityResolver delegate = new DelegatedEntityResolver();
        delegate.addEntityResolver((EntityResolver)localEntityResolver, "LocalEntityResolver for bundle " + OsgiStringUtils.nullSafeNameAndSymName(this.getBundle()));
        delegate.addEntityResolver(osgiServiceEntityResolver, "OSGi Service resolver");
        return delegate;
    }

    private NamespaceHandlerResolver lookupNamespaceHandlerResolver(Object fallbackObject) {
        return (NamespaceHandlerResolver)TrackingUtil.getService(new Class[]{NamespaceHandlerResolver.class}, null, this.getClassLoader(), this.getBundleContext(), fallbackObject);
    }

    private EntityResolver lookupEntityResolver(Object fallbackObject) {
        return (EntityResolver)TrackingUtil.getService(new Class[]{EntityResolver.class}, null, this.getClassLoader(), this.getBundleContext(), fallbackObject);
    }

    protected void initBeanDefinitionReader(XmlBeanDefinitionReader beanDefinitionReader) {
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws BeansException, IOException {
        String[] configLocations = this.getConfigLocations();
        if (configLocations != null) {
            for (int i = 0; i < configLocations.length; ++i) {
                reader.loadBeanDefinitions(configLocations[i]);
            }
        }
    }

    protected String[] getDefaultConfigLocations() {
        return new String[]{DEFAULT_CONFIG_LOCATION};
    }
}

