/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver.backend.base.wsdl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.eclipse.swordfish.internal.resolver.backend.base.wsdl.SwordfishPort;
import org.eclipse.swordfish.internal.resolver.backend.base.wsdl.Transport;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwordfishPortImpl
implements SwordfishPort {
    private static final long serialVersionUID = 2250071086424670955L;
    private Port port;
    private Transport transport;
    private boolean interpreted;

    public SwordfishPortImpl(Port port) {
        this.port = port;
    }

    public SwordfishPortImpl(Port port, Transport transport) {
        this(port);
        this.transport = transport;
    }

    @Override
    public Transport getTransport() {
        if (!this.interpreted) {
            this.interpret();
        }
        return this.transport;
    }

    private void interpret() {
        if (this.transport == null) {
            ExtensibilityElement element;
            SOAPBinding binding = null;
            Iterator iterator = this.port.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                element = (ExtensibilityElement)iterator.next();
                if (!(element instanceof SOAPBinding)) continue;
                binding = (SOAPBinding)element;
                break;
            }
            if (binding != null) {
                if (binding.getTransportURI().equals("http://schemas.xmlsoap.org/soap/jms")) {
                    this.transport = Transport.JMS;
                } else if (binding.getTransportURI().equals("http://schemas.xmlsoap.org/soap/http") && (iterator = this.port.getExtensibilityElements().iterator()).hasNext() && (element = (ExtensibilityElement)iterator.next()) instanceof SOAPAddress) {
                    String uri = ((SOAPAddress)element).getLocationURI();
                    this.transport = uri.toLowerCase().startsWith("https") ? Transport.HTTPS : Transport.HTTP;
                }
            }
            if (this.transport == null) {
                this.transport = Transport.UNKNOWN;
            }
        }
        this.interpreted = true;
    }

    @Override
    public void addExtensibilityElement(ExtensibilityElement element) {
        this.port.addExtensibilityElement(element);
    }

    @Override
    public Binding getBinding() {
        return this.port.getBinding();
    }

    @Override
    public Element getDocumentationElement() {
        return this.port.getDocumentationElement();
    }

    @Override
    public List<?> getExtensibilityElements() {
        return this.port.getExtensibilityElements();
    }

    @Override
    public String getName() {
        return this.port.getName();
    }

    @Override
    public void setBinding(Binding binding) {
        this.port.setBinding(binding);
    }

    @Override
    public void setDocumentationElement(Element element) {
        this.port.setDocumentationElement(element);
    }

    @Override
    public void setName(String arg0) {
        this.port.setName(arg0);
    }

    @Override
    public void setExtensionAttribute(QName arg0, Object arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getExtensionAttribute(QName attributeName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<?, ?> getExtensionAttributes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<?> getNativeAttributeNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExtensibilityElement removeExtensibilityElement(ExtensibilityElement element) {
        return element;
    }
}

