/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver.backend.base.wsdl11;

import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import org.eclipse.swordfish.core.resolver.EndpointDescription;
import org.eclipse.swordfish.core.resolver.registry.EndpointExtractor;
import org.eclipse.swordfish.core.resolver.registry.ServiceDescription;
import org.eclipse.swordfish.internal.resolver.backend.base.wsdl.WSDLEndpointDescription;
import org.eclipse.swordfish.internal.resolver.backend.base.wsdl11.WSDL11ServiceDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL11EndpointExtractor
implements EndpointExtractor {
    private Class<Definition> descriptionType = Definition.class;

    public boolean canHandle(ServiceDescription<?> description) {
        return description != null && this.descriptionType.equals(description.getType());
    }

    public EndpointDescription extractEndpoint(ServiceDescription<?> serviceDescription) {
        WSDLEndpointDescription endpoint = new WSDLEndpointDescription();
        WSDL11ServiceDescription wsdlDescription = null;
        String endpointAddress = null;
        if (serviceDescription == null) {
            throw new IllegalArgumentException("ServiceDescription argument can not be null.");
        }
        wsdlDescription = (WSDL11ServiceDescription)WSDL11ServiceDescription.class.cast(serviceDescription);
        Iterator<Map.Entry<SOAPAddress, SOAPBinding>> iterator = wsdlDescription.getAvailableLocations().entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<SOAPAddress, SOAPBinding> entry = iterator.next();
            endpointAddress = entry.getKey().getLocationURI();
            endpoint.setAddress(String.valueOf(endpointAddress) + "?http.soap=true");
            endpoint.setEndpointTransport(entry.getValue().getTransportURI());
        }
        endpoint.setServiceDescription(serviceDescription);
        endpoint.setName(wsdlDescription.getPortName(endpointAddress, endpoint.getEndpointTransport()));
        return endpoint;
    }
}

