/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver.backend.base.wsdl11;

import java.io.Reader;
import java.net.URL;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.eclipse.swordfish.core.resolver.registry.ServiceDescription;
import org.eclipse.swordfish.internal.resolver.backend.base.wsdl.ServiceDescriptionReader;
import org.eclipse.swordfish.internal.resolver.backend.base.wsdl11.WSDL11ServiceDescription;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL11ServiceDescriptionReader
implements ServiceDescriptionReader<Definition> {
    private static WSDLFactory factory;

    private void initWSDLFactory() {
        try {
            factory = WSDLFactory.newInstance();
        }
        catch (WSDLException e) {
            throw new IllegalStateException("Couldn't instantiate WSDLFactory.", e);
        }
    }

    private WSDLReader createReader() throws WSDLException {
        if (factory == null) {
            this.initWSDLFactory();
        }
        WSDLReader reader = factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        return reader;
    }

    @Override
    public ServiceDescription<Definition> readDescription(Reader description) {
        WSDL11ServiceDescription resultDescription;
        if (description == null) {
            throw new IllegalArgumentException("Service description can not be null.");
        }
        try {
            InputSource inputSource = new InputSource(description);
            Definition definition = this.createReader().readWSDL(null, inputSource);
            resultDescription = new WSDL11ServiceDescription(definition);
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't read service description", e);
        }
        return resultDescription;
    }

    @Override
    public ServiceDescription<Definition> readDescription(URL descriptionURL) {
        WSDL11ServiceDescription resultDescription;
        if (descriptionURL == null) {
            throw new IllegalArgumentException("Service description URI can not be null.");
        }
        try {
            Definition definition = this.createReader().readWSDL(descriptionURL.toString());
            resultDescription = new WSDL11ServiceDescription(definition);
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't read service description", e);
        }
        return resultDescription;
    }

    static void setFactory(WSDLFactory factory) {
        WSDL11ServiceDescriptionReader.factory = factory;
    }
}

