/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.registry;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.registry.IncorrectRequestException;
import org.eclipse.swordfish.registry.Resource;
import org.eclipse.swordfish.registry.Router;
import org.eclipse.swordfish.registry.VerbNotSupportedException;

public class WSILServlet
extends HttpServlet {
    private static final long serialVersionUID = -8376659320998034145L;
    private static final Log LOGGER = LogFactory.getLog(WSILServlet.class);
    private Router router;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        System.out.println("getPathInfo: " + req.getPathInfo());
        System.out.println("getServletInfo: " + req.getServletPath());
        LOGGER.info((Object)("Received request:\n" + req.getRequestURL()));
        Resource resource = null;
        try {
            resource = this.router.getResource(req);
        }
        catch (IncorrectRequestException e) {
            resp.sendError(e.getErrorCode(), e.getErrorMessage());
            return;
        }
        try {
            resp.setContentType(resource.getContentType());
            resp.setCharacterEncoding(resource.getCharacterEncoding());
            resource.get(resp.getWriter());
        }
        catch (VerbNotSupportedException verbNotSupportedException) {
            resp.sendError(400, "Delete is not supported for " + req.getRequestURL());
            return;
        }
    }

    public void setRouter(Router router) {
        this.router = router;
    }
}

