/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.configuration;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.configuration.ConfigurationService;
import org.eclipse.swordfish.core.configuration.access.ConfigurationAgent;
import org.eclipse.swordfish.core.event.ConfigurationEvent;
import org.eclipse.swordfish.core.event.EventConstants;
import org.eclipse.swordfish.core.event.EventFilter;
import org.eclipse.swordfish.core.event.EventHandler;
import org.eclipse.swordfish.core.event.Severity;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationAgentImpl
implements EventHandler<ConfigurationEvent>,
ConfigurationAgent {
    private static final Log LOG = LogFactory.getLog(ConfigurationAgentImpl.class);
    private ConfigurationService configurationService;

    public Severity getSeverity() {
        return null;
    }

    public String getSubscribedTopic() {
        return EventConstants.TOPIC_CONFIGURATION_EVENT;
    }

    public void handleEvent(ConfigurationEvent configurationEvent) {
        LOG.info((Object)("Received configuration event " + configurationEvent));
        if (configurationEvent != null && configurationEvent.getConfiguration() != null) {
            this.handleConfiguration(configurationEvent.getConfiguration());
        }
    }

    @Override
    public void handleConfiguration(Map<String, ?> configurations) {
        Assert.notNull(configurations);
        Assert.notNull((Object)this.configurationService);
        for (String id : configurations.keySet()) {
            Object configuration = configurations.get(id);
            if (!(configuration instanceof Map)) {
                throw new UnsupportedOperationException("Only map based configuration is supported as for now");
            }
            this.configurationService.updateConfiguration(id, (Map)configuration);
        }
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public EventFilter getEventFilter() {
        return null;
    }
}

