/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.binding.corba.wsdl.NamedType;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;

public class CorbaTypeMap {
    private String targetNamespace;
    private Map<String, CorbaTypeImpl> typeMap;
    private Map<QName, TypeCode> typeCodeMap;

    public CorbaTypeMap(String namespace) {
        this.targetNamespace = namespace;
        this.typeMap = new HashMap<String, CorbaTypeImpl>();
        this.typeCodeMap = new HashMap<QName, TypeCode>();
    }

    public void addType(String name, CorbaTypeImpl type) {
        this.typeMap.put(name, type);
    }

    public CorbaTypeImpl getType(String name) {
        assert (name != null);
        return this.typeMap.get(name);
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void addTypeCode(QName name, TypeCode tc) {
        this.typeCodeMap.put(name, tc);
    }

    public TypeCode getTypeCode(QName name) {
        return this.typeCodeMap.get(name);
    }

    public QName getIdlType(TypeCode tc) {
        String repId = null;
        try {
            repId = tc.id();
        }
        catch (BadKind ex) {
            return null;
        }
        if (repId == null) {
            return null;
        }
        Set<Map.Entry<String, CorbaTypeImpl>> mapSet = this.typeMap.entrySet();
        for (Map.Entry<String, CorbaTypeImpl> entry : mapSet) {
            NamedType n;
            if (!(entry.getValue() instanceof NamedType) || !(n = (NamedType)entry.getValue()).getRepositoryID().equals(repId)) continue;
            return new QName(this.getTargetNamespace(), entry.getKey());
        }
        return null;
    }
}

