/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.planner;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.swordfish.core.Interceptor;
import org.eclipse.swordfish.core.planner.strategy.FilterStrategy;
import org.eclipse.swordfish.core.planner.strategy.Hint;
import org.eclipse.swordfish.core.util.ReadOnlyRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreFilterStrategy
implements FilterStrategy {
    public static final String CORE_INTERCEPTOR_NAMESPACE = "http://interceptor.core.internal.swordfish.eclipse.org/";

    @Override
    public List<Interceptor> filter(List<Interceptor> interceptors, ReadOnlyRegistry<Interceptor> registry, List<Hint<?>> hints) {
        ArrayList<Interceptor> validInterceptors = new ArrayList<Interceptor>();
        for (Interceptor interceptor : interceptors) {
            if (!this.isCoreInterceptor(interceptor, registry)) continue;
            validInterceptors.add(interceptor);
        }
        return validInterceptors;
    }

    private boolean isCoreInterceptor(Interceptor interceptor, ReadOnlyRegistry<Interceptor> registry) {
        QName typeProperty = this.getTypeProperty(interceptor, registry);
        return typeProperty != null && typeProperty.getNamespaceURI().equals(CORE_INTERCEPTOR_NAMESPACE);
    }

    private QName getTypeProperty(Interceptor candidateInterceptor, ReadOnlyRegistry<Interceptor> registry) {
        Map interceptorProperties = registry.getProperties((Object)candidateInterceptor);
        Object typeProperty = interceptorProperties.get("type");
        if (typeProperty != null && typeProperty instanceof QName) {
            return (QName)typeProperty;
        }
        return null;
    }

    @Override
    public int getPriority() {
        return 0;
    }
}

