/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver.policy.extractor;

import java.io.InputStream;
import org.apache.cxf.ws.policy.PolicyBuilderImpl;
import org.apache.neethi.Policy;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.core.resolver.policy.DomBasedWsPolicyDefinitionDescription;
import org.eclipse.swordfish.core.resolver.policy.PolicyDefinitionDescription;
import org.eclipse.swordfish.core.resolver.policy.PolicyDescription;
import org.eclipse.swordfish.core.resolver.policy.PolicyExtractor;
import org.eclipse.swordfish.core.resolver.policy.PolicyRole;
import org.eclipse.swordfish.core.resolver.policy.PolicyStatus;
import org.eclipse.swordfish.core.resolver.policy.StreamBasedWsPolicyDefinitionDescription;
import org.eclipse.swordfish.internal.resolver.policy.helpers.PolicyBuilderInitializer;
import org.eclipse.swordfish.internal.resolver.policy.processor.WsPolicyDescription;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsPolicyExtractor
implements PolicyExtractor {
    private PolicyBuilderInitializer policyBuilderInitializer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Policy extractPolicy(Element element) {
        PolicyBuilderInitializer policyBuilderInitializer = this.policyBuilderInitializer;
        synchronized (policyBuilderInitializer) {
            PolicyBuilderImpl pb = this.policyBuilderInitializer.getPolicyBuilder();
            return pb.getPolicy(element);
        }
    }

    public Policy extractPolicy(InputStream inputStream) {
        PolicyBuilderInitializer policyBuilderInitializer = this.policyBuilderInitializer;
        synchronized (policyBuilderInitializer) {
            PolicyBuilderImpl pb = this.policyBuilderInitializer.getPolicyBuilder();
            try {
                return pb.getPolicy(inputStream);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public PolicyDescription<Policy> extractPolicy(PolicyDefinitionDescription policyDefinition) {
        if (policyDefinition != null) {
            if (policyDefinition instanceof StreamBasedWsPolicyDefinitionDescription) {
                return this.doExtractPolicy((StreamBasedWsPolicyDefinitionDescription)policyDefinition);
            }
            if (policyDefinition instanceof DomBasedWsPolicyDefinitionDescription) {
                return this.doExtractPolicy((DomBasedWsPolicyDefinitionDescription)policyDefinition);
            }
        }
        throw new IllegalArgumentException("Bad policy definition argument provided. ");
    }

    public Class<Policy> getPlatformPolicyType() {
        return Policy.class;
    }

    public boolean isSupportedType(Class<? extends PolicyDefinitionDescription> type) {
        return StreamBasedWsPolicyDefinitionDescription.class.isAssignableFrom(type) || DomBasedWsPolicyDefinitionDescription.class.isAssignableFrom(type);
    }

    public PolicyBuilderInitializer getPolicyBuilderInitializer() {
        return this.policyBuilderInitializer;
    }

    public void setPolicyBuilderInitializer(PolicyBuilderInitializer policyBuilderInitializer) {
        this.policyBuilderInitializer = policyBuilderInitializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolicyDescription<Policy> doExtractPolicy(StreamBasedWsPolicyDefinitionDescription policyDefinition) {
        try {
            Policy policy;
            PolicyBuilderInitializer policyBuilderInitializer = this.policyBuilderInitializer;
            synchronized (policyBuilderInitializer) {
                PolicyBuilderImpl pb = this.policyBuilderInitializer.getPolicyBuilder();
                policy = pb.getPolicy(policyDefinition.getPolicyStream());
            }
            WsPolicyDescription p = new WsPolicyDescription();
            p.setPolicy(policy);
            p.setPolicyRole(PolicyRole.UNKNOWN);
            p.setPolicyStatus(PolicyStatus.UNKNOWN);
            return p;
        }
        catch (Exception e) {
            throw new SwordfishException("Corrupted policy. ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolicyDescription<Policy> doExtractPolicy(DomBasedWsPolicyDefinitionDescription policyDefinition) {
        try {
            Policy policy;
            PolicyBuilderInitializer policyBuilderInitializer = this.policyBuilderInitializer;
            synchronized (policyBuilderInitializer) {
                PolicyBuilderImpl pb = this.policyBuilderInitializer.getPolicyBuilder();
                policy = pb.getPolicy(policyDefinition.getPolicyElement());
            }
            WsPolicyDescription p = new WsPolicyDescription();
            p.setPolicy(policy);
            p.setPolicyRole(PolicyRole.UNKNOWN);
            p.setPolicyStatus(PolicyStatus.UNKNOWN);
            return p;
        }
        catch (Exception e) {
            throw new SwordfishException("Corrupted policy. ", (Throwable)e);
        }
    }
}

