/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver.policy.helpers;

import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.PolicyBuilderImpl;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.policy.builder.xml.XMLPrimitiveAssertionBuilder;
import org.eclipse.swordfish.core.Interceptor;
import org.eclipse.swordfish.core.planner.Planner;

public class PolicyBuilderInitializer {
    private static final Log LOG = LogFactory.getLog(PolicyBuilderInitializer.class);
    private PolicyBuilderImpl policyBuilder;
    private boolean isInitialized = false;
    private Planner planner;

    public PolicyBuilderImpl getPolicyBuilder() {
        this.initPolicyBuilder();
        return this.policyBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPolicyBuilder(PolicyBuilderImpl policyBuilder) {
        if (this.policyBuilder == policyBuilder) {
            return;
        }
        PolicyBuilderInitializer policyBuilderInitializer = this;
        synchronized (policyBuilderInitializer) {
            this.policyBuilder = policyBuilder;
            this.isInitialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlanner(Planner planner) {
        if (this.planner == planner) {
            return;
        }
        PolicyBuilderInitializer policyBuilderInitializer = this;
        synchronized (policyBuilderInitializer) {
            this.planner = planner;
        }
    }

    private synchronized void initPolicyBuilder() {
        if (this.policyBuilder == null) {
            return;
        }
        if (this.isInitialized) {
            ((PolicyConstants)this.policyBuilder.getBus().getExtension(PolicyConstants.class)).setNamespace("http://schemas.xmlsoap.org/ws/2004/09/policy");
            return;
        }
        XMLPrimitiveAssertionBuilder xmlPrimitiveAssertionBuilder = new XMLPrimitiveAssertionBuilder();
        ArrayList<QName> knownElements = new ArrayList<QName>();
        for (Interceptor interceptor : this.planner.getRegisteredInterceptors()) {
            Map props = interceptor.getProperties();
            if (!props.containsKey("type") || !(props.get("type") instanceof QName)) continue;
            knownElements.add((QName)props.get("type"));
            LOG.info((Object)("Adding " + props.get("type").toString() + " to the list of supported policy assertions."));
        }
        xmlPrimitiveAssertionBuilder.setKnownElements(knownElements);
        AssertionBuilderRegistry assertionBuilderRegistry = this.policyBuilder.getAssertionBuilderRegistry();
        assertionBuilderRegistry.setIgnoreUnknownAssertions(false);
        for (QName elem : xmlPrimitiveAssertionBuilder.getKnownElements()) {
            assertionBuilderRegistry.register((Object)elem, (Object)xmlPrimitiveAssertionBuilder);
        }
        PolicyConstants constants = new PolicyConstants();
        constants.setNamespace("http://schemas.xmlsoap.org/ws/2004/09/policy");
        this.policyBuilder.getBus().setExtension((Object)constants, PolicyConstants.class);
        this.isInitialized = true;
    }
}

