/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.util.concurrent;

import org.springframework.osgi.extender.internal.util.concurrent.Counter;
import org.springframework.util.Assert;

public abstract class RunnableTimedExecution {
    public static boolean execute(Runnable task, long waitTime) {
        Assert.notNull((Object)task);
        Counter counter = new Counter("counter for task: " + task);
        MonitoredRunnable wrapper = new MonitoredRunnable(task, counter);
        counter.increment();
        Thread thread = new Thread(wrapper);
        thread.start();
        if (counter.waitForZero(waitTime)) {
            thread.stop();
            return true;
        }
        return false;
    }

    private static class MonitoredRunnable
    implements Runnable {
        private Runnable task;
        private Counter counter;

        public MonitoredRunnable(Runnable task, Counter counter) {
            this.task = task;
            this.counter = counter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.task.run();
            }
            finally {
                this.counter.decrement();
            }
        }
    }
}

