/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.plugins.compression;

import java.util.HashMap;
import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.plugins.compression.AbstractInterceptor;
import org.eclipse.swordfish.plugins.compression.Compressor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompressionInterceptor
extends AbstractInterceptor {
    private static final Log LOG = LogFactory.getLog(CompressionInterceptor.class);
    private static Map<String, Object> properties = new HashMap<String, Object>();
    private Compressor compressor;

    static {
        properties.put("type", new QName("http://www.eclipse.org/swordfish/schemas/policy", "Compression"));
    }

    public void setCompressor(Compressor compressor) {
        this.compressor = compressor;
    }

    @Override
    public Map<String, ?> getProperties() {
        return properties;
    }

    @Override
    protected void processConsumerRequest(MessageExchange exchange) {
        this.compress(this.getRequestMessage(exchange));
    }

    @Override
    protected void processProviderRequest(MessageExchange exchange) {
        this.uncompress(this.getRequestMessage(exchange));
    }

    @Override
    protected void processProviderResponse(MessageExchange exchange) {
        this.compress(this.getResponseMessage(exchange));
    }

    @Override
    protected void processConsumerResponse(MessageExchange exchange) {
        this.uncompress(this.getResponseMessage(exchange));
    }

    private void compress(NormalizedMessage nm) {
        Source src = nm.getContent();
        if (this.compressor.isSourceEmpty(src)) {
            LOG.warn((Object)"No payload to compress.");
            return;
        }
        try {
            Source compressed = this.compressor.asCompressedSource(src);
            nm.setContent(compressed);
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            throw new SwordfishException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void uncompress(NormalizedMessage nm) {
        Source src = nm.getContent();
        if (this.compressor.isSourceEmpty(src)) {
            LOG.warn((Object)"No payload to uncompress.");
            return;
        }
        try {
            Source compressed = this.compressor.asUncompressedSource(src);
            nm.setContent(compressed);
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            throw new SwordfishException(ex.getMessage(), (Throwable)ex);
        }
    }
}

