/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.plugins.compression;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.plugins.compression.Compressor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class CompressorImpl
implements Compressor {
    private static final Log LOG = LogFactory.getLog(CompressorImpl.class);
    private static final String COMPRESSION_ELEMENT_NS = "http://www.eclipse.org/swordfish/interceptors/Compression/1.0";
    private static final String COMPRESSION_ELEMENT_LOCALNAME = "GZIPCompressed";
    private static final String COMPRESSION_ELEMENT_PREFIX = "swf";

    public boolean isSourceEmpty(Source src) {
        InputStream is;
        if (src == null) {
            return true;
        }
        if (src instanceof DOMSource) {
            Node node = ((DOMSource)src).getNode();
            if (node == null) {
                return true;
            }
            if (node instanceof Document && !node.hasChildNodes()) {
                return true;
            }
        } else if (src instanceof StreamSource && (is = ((StreamSource)src).getInputStream()) == null) {
            return true;
        }
        return false;
    }

    public Source asCompressedSource(Source src) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream zipped = new GZIPOutputStream(baos);
            StreamResult result = new StreamResult(zipped);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(src, result);
            zipped.finish();
            byte[] compressedBytes = baos.toByteArray();
            String encoded = new String(new Base64().encode(compressedBytes));
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element wrapper = doc.createElementNS(COMPRESSION_ELEMENT_NS, "swf:GZIPCompressed");
            wrapper.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:swf", COMPRESSION_ELEMENT_NS);
            wrapper.appendChild(doc.createTextNode(encoded));
            doc.appendChild(wrapper);
            return new DOMSource(doc);
        }
        catch (Exception e) {
            throw new SwordfishException((Throwable)e);
        }
    }

    public Source asUncompressedSource(Source src) {
        try {
            String encoded = null;
            if (src instanceof DOMSource) {
                Node node;
                Element rootElement;
                String qName;
                String localName;
                Node root = ((DOMSource)src).getNode();
                if (root instanceof Document) {
                    root = ((Document)root).getDocumentElement();
                }
                if ((localName = (qName = (rootElement = (Element)root).getNodeName()).substring(qName.indexOf(":") + 1, qName.length())).equalsIgnoreCase(COMPRESSION_ELEMENT_LOCALNAME) && (node = rootElement.getFirstChild()) != null && node.getNodeType() == 3) {
                    encoded = node.getNodeValue();
                }
                if (encoded != null && encoded.length() > 0) {
                    byte[] decoded = new Base64().decode(encoded.getBytes());
                    GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(decoded));
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document doc = builder.parse(is);
                    return new DOMSource(doc);
                }
                throw new SwordfishException("Payload is empty, cannot uncompress.");
            }
            if (src instanceof StreamSource) {
                XMLReader xmlReader = XMLReaderFactory.createXMLReader();
                CompressedContentHandler ch = new CompressedContentHandler();
                xmlReader.setContentHandler(ch);
                xmlReader.parse(new InputSource(((StreamSource)src).getInputStream()));
                encoded = ch.getContent();
                if (encoded != null && encoded.length() > 0) {
                    byte[] decoded = new Base64().decode(encoded.getBytes());
                    GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(decoded));
                    return new StreamSource(is);
                }
                throw new SwordfishException("Payload is empty, cannot uncompress.");
            }
            return this.asUncompressedSource(new SourceTransformer().toDOMSource(src));
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new SwordfishException((Throwable)e);
        }
    }

    private class CompressedContentHandler
    implements ContentHandler {
        private int state = 0;
        private final StringBuilder buf = new StringBuilder();
        private final Map<String, String> prefixes = new HashMap<String, String>();

        private CompressedContentHandler() {
        }

        public void startDocument() throws SAXException {
            ++this.state;
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.state == 1 && localName.equalsIgnoreCase(CompressorImpl.COMPRESSION_ELEMENT_LOCALNAME) && uri.equalsIgnoreCase(CompressorImpl.COMPRESSION_ELEMENT_NS)) {
                ++this.state;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.state == 2) {
                this.buf.append(new String(ch, start, length));
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.state == 2 && localName.equalsIgnoreCase(CompressorImpl.COMPRESSION_ELEMENT_LOCALNAME) && uri.equalsIgnoreCase(CompressorImpl.COMPRESSION_ELEMENT_NS)) {
                ++this.state;
            }
        }

        public void endDocument() throws SAXException {
            if (this.state == 3) {
                ++this.state;
            }
        }

        public String getContent() {
            if (this.state == 4) {
                return this.buf.toString();
            }
            return null;
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.prefixes.put(prefix, uri);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.prefixes.remove(prefix);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String name) throws SAXException {
        }
    }
}

