/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.interceptor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.runtime.ComponentRegistry;
import org.apache.servicemix.jbi.runtime.ComponentWrapper;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.Reference;
import org.apache.servicemix.nmr.api.Role;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.core.ChannelImpl;
import org.apache.servicemix.nmr.core.EndpointRegistryImpl;
import org.apache.servicemix.nmr.core.ExchangeImpl;
import org.apache.servicemix.nmr.core.InternalEndpointWrapper;
import org.apache.servicemix.nmr.core.PropertyMatchingReference;
import org.apache.servicemix.nmr.core.StaticReferenceImpl;
import org.eclipse.swordfish.core.Interceptor;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.core.resolver.EndpointDescription;
import org.eclipse.swordfish.core.resolver.EndpointMetadata;
import org.eclipse.swordfish.core.resolver.ServiceResolver;
import org.eclipse.swordfish.internal.core.resolver.ServiceResolverHolder;
import org.eclipse.swordfish.internal.core.util.smx.ServiceMixSupport;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.w3c.dom.DocumentFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointResolverInterceptor
implements Interceptor,
ServiceResolverHolder,
InitializingBean {
    private static final Log LOG = LogFactory.getLog(EndpointResolverInterceptor.class);
    public static final String TARGETTED_TO_EXTERNAL_ENDPOINT_ME_PROPERTY = "TARGETTED_TO_EXTERNAL_ENDPOINT_ME_PROPERTY";
    private NMR nmr;
    private ServiceResolver serviceResolver;
    private ComponentRegistry componentRegistry;
    private final Map<String, ?> properties = new HashMap();

    private void setDummyExchangeDestination(Exchange exchange) {
        try {
            exchange.setTarget(null);
            InternalEndpointWrapper internalEndpointWrapper = new InternalEndpointWrapper(new Endpoint(){

                public void process(Exchange exchange) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("The stub has processed the exchange " + exchange));
                    }
                }

                public void setChannel(Channel arg0) {
                }
            }, new HashMap());
            internalEndpointWrapper.setChannel((Channel)new ChannelImpl((InternalEndpoint)internalEndpointWrapper, ((EndpointRegistryImpl)this.nmr.getEndpointRegistry()).getExecutorFactory().createExecutor(String.valueOf(EndpointResolverInterceptor.class.getSimpleName()) + "MockExecutor"), this.nmr));
            ArrayList<InternalEndpointWrapper> internalEndpoints = new ArrayList<InternalEndpointWrapper>();
            internalEndpoints.add(internalEndpointWrapper);
            exchange.setTarget((Reference)new StaticReferenceImpl(internalEndpoints));
            if (exchange instanceof ExchangeImpl) {
                ExchangeImpl exchangeImpl = (ExchangeImpl)exchange;
                exchangeImpl.setDestination((InternalEndpoint)internalEndpointWrapper);
            }
        }
        catch (Exception ex) {
            LOG.info((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void process(MessageExchange messageExchange) throws SwordfishException {
        Exchange exchange = ServiceMixSupport.toNMRExchange((MessageExchange)messageExchange);
        try {
            if (messageExchange.getStatus() == ExchangeStatus.DONE) {
                LOG.warn((Object)"could't process terminated (status == DONE) message exchange!");
                this.setDummyExchangeDestination(exchange);
                return;
            }
            if (exchange.getRole() != Role.Consumer) {
                return;
            }
            if (exchange.getTarget() != null && ServiceMixSupport.getEndpoint((NMR)this.getNmr(), (Reference)exchange.getTarget()) != null) {
                return;
            }
            this.handleWrongInterfaceNameTargetProperty(exchange);
            QName interfaceName = this.getInterfaceName(exchange);
            if (interfaceName == null) {
                return;
            }
            QName operation = exchange.getOperation();
            if (operation == null) {
                return;
            }
            EndpointDescription description = this.getEndpointDescription(interfaceName, this.extractConsumerName(exchange));
            if (description == null) {
                throw new SwordfishException("Error resolving endpoint - no service description has been found for the interface: " + interfaceName);
            }
            InternalEndpoint serviceEndpoint = this.getEndpointForExchange(messageExchange, description);
            if (serviceEndpoint == null) {
                throw new SwordfishException("Error resolving endpoint for the interface + [" + interfaceName + "] - no suitable endpoints have been found");
            }
            if (description.getMetadata() != null && this.isTargettedToExternalEndpoint(exchange, serviceEndpoint)) {
                exchange.setProperty("org.eclipse.swordfish.core.resolver.EndpointMetadata", (Object)description.getMetadata());
                this.createSoapHeader(exchange);
            }
            exchange.setTarget((Reference)new StaticReferenceImpl(Arrays.asList(serviceEndpoint)));
        }
        catch (Exception ex) {
            LOG.error((Object)"An exception occured while trying to resolve service name via supplied wsdls ", (Throwable)ex);
        }
    }

    private void handleWrongInterfaceNameTargetProperty(Exchange exchange) {
        try {
            Map props = this.getTargetEndpointPrefereces(exchange);
            if (props != null && props.containsKey("SERVICE_NAME")) {
                HashMap newProps = new HashMap();
                newProps.put("SERVICE_NAME", props.get("SERVICE_NAME"));
                InternalEndpoint serviceEndpoint = ServiceMixSupport.getEndpoint((NMR)this.getNmr(), newProps);
                if (serviceEndpoint != null) {
                    exchange.setTarget((Reference)new StaticReferenceImpl(Arrays.asList(serviceEndpoint)));
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"The exception while trying to access endpoint via the SERVICE_NAME property ", (Throwable)ex);
        }
    }

    private QName getInterfaceName(Exchange exchange) {
        QName interfaceName = (QName)exchange.getProperty("INTERFACE_NAME");
        if (interfaceName == null && (interfaceName = (QName)exchange.getProperty("javax.jbi.InterfaceName")) == null) {
            Map props = this.getTargetEndpointPrefereces(exchange);
            String interfaceNameString = props != null ? (String)props.get("INTERFACE_NAME") : null;
            interfaceName = interfaceNameString != null ? QName.valueOf(interfaceNameString) : null;
        }
        return interfaceName;
    }

    private Map getTargetEndpointPrefereces(Exchange exchange) {
        Map result = null;
        try {
            if (exchange.getTarget() != null && exchange.getTarget() instanceof PropertyMatchingReference) {
                PropertyMatchingReference propertyMatchingReference = (PropertyMatchingReference)exchange.getTarget();
                Field propertiesField = PropertyMatchingReference.class.getDeclaredField("properties");
                propertiesField.setAccessible(true);
                result = (Map)propertiesField.get(propertyMatchingReference);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"The exception while trying to access endpoint preferences ", (Throwable)ex);
        }
        return result;
    }

    private boolean isTargettedToExternalEndpoint(Exchange exchange, InternalEndpoint serviceEndpoint) {
        if (exchange.getProperties().containsKey(TARGETTED_TO_EXTERNAL_ENDPOINT_ME_PROPERTY) && exchange.getProperty(TARGETTED_TO_EXTERNAL_ENDPOINT_ME_PROPERTY).equals(Boolean.TRUE)) {
            return true;
        }
        return serviceEndpoint.getMetaData().containsKey("TYPE") && serviceEndpoint.getMetaData().get("TYPE").equals("binding-component");
    }

    private void createSoapHeader(Exchange exchange) {
        EndpointMetadata metadata = (EndpointMetadata)exchange.getProperty("org.eclipse.swordfish.core.resolver.EndpointMetadata");
        HashMap<QName, DocumentFragment> headers = new HashMap<QName, DocumentFragment>();
        headers.put(new QName("http://eclipse.org/swordfish/headers", "Policy"), metadata.toXml());
        exchange.getIn().setHeader("org.apache.servicemix.soap.headers", headers);
    }

    private EndpointDescription getEndpointDescription(QName interfaceName, QName consumerName) {
        EndpointDescription description = null;
        Collection descriptions = this.getServiceResolver().getEndpointsFor(interfaceName, consumerName);
        if (descriptions.size() > 0) {
            description = (EndpointDescription)descriptions.iterator().next();
        }
        return description;
    }

    private InternalEndpoint getEndpointForExchange(MessageExchange messageExchange, EndpointDescription description) {
        QName serviceName = description.getServiceName();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("SERVICE_NAME", serviceName.toString());
        InternalEndpoint serviceEndpoint = ServiceMixSupport.getEndpoint((NMR)this.getNmr(), props);
        if (serviceEndpoint != null) {
            LOG.info((Object)("The service endpoint for the servicename + [" + serviceName + "] has been found"));
        } else {
            LOG.info((Object)("No service endpoints for the service + [" + serviceName + "] have been found"));
            LOG.info((Object)("Trying to establish a dynamic outbound endpoint for the service: " + serviceName));
            ServiceEndpoint se = null;
            ComponentWrapper wrapper = null;
            DocumentFragment endpRef = ServiceMixSupport.getEndpointReference((EndpointDescription)description);
            for (ComponentWrapper component : this.getComponentRegistry().getServices()) {
                se = component.getComponent().resolveEndpointReference(endpRef);
                if (se == null) continue;
                wrapper = component;
                break;
            }
            if (wrapper != null && se != null) {
                Map compProps = this.getComponentRegistry().getProperties(wrapper);
                props = new HashMap();
                if (compProps.containsKey("NAME")) {
                    Object compName = compProps.get("NAME");
                    props.put("NAME", (String)compName);
                }
                if (compProps.containsKey("TYPE")) {
                    Object compType = compProps.get("TYPE");
                    props.put("TYPE", (String)compType);
                }
                if ((serviceEndpoint = ServiceMixSupport.getEndpoint((NMR)this.getNmr(), props)) != null) {
                    LOG.info((Object)("Succesfully established an outbound endpoint for the service: " + serviceName));
                    messageExchange.setProperty(TARGETTED_TO_EXTERNAL_ENDPOINT_ME_PROPERTY, (Object)true);
                    messageExchange.setEndpoint(se);
                } else {
                    LOG.warn((Object)("Couldn't get an endpoint for the service: " + serviceName));
                }
            } else {
                LOG.warn((Object)("Couldn't get an endpoint for the service: " + serviceName));
            }
        }
        return serviceEndpoint;
    }

    public NMR getNmr() {
        return this.nmr;
    }

    public void setNmr(NMR nmr) {
        this.nmr = nmr;
    }

    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    public void setComponentRegistry(ComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    @Override
    public ServiceResolver getServiceResolver() {
        return this.serviceResolver;
    }

    @Override
    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }

    public Map<String, ?> getProperties() {
        return this.properties;
    }

    public String getId() {
        return this.getClass().getName();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.nmr);
        Assert.notNull((Object)this.componentRegistry);
        Assert.notNull((Object)this.serviceResolver);
    }

    private QName extractConsumerName(Exchange xch) {
        Object o = xch.getProperty("org.eclipse.swordfish.policy.ConsumerName");
        return o instanceof QName ? (QName)o : null;
    }
}

