/*******************************************************************************
 * Copyright (c) 2008, 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import org.apache.cxf.tools.common.ToolException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swordfish.tooling.ui.Activator;
import org.eclipse.swordfish.tooling.ui.Messages;

/**
 * Utility class used for Error Dialog display functions
 */

public class ErrorUtil {
	/**
	 * method using to receive fine styled output in "Details" area of Error Dialog Window
	 * it generate incoming exception message string and create IStatus object for each line of this string
	 * in case if this is multyline text, otherwise details message will be displayed as one-line string
	 * @param initial exception
	 * @return array of IStatus instances 
	 */
	public static IStatus getErrorStatus(String message, Throwable exception){
		List<IStatus> statusList = new ArrayList<IStatus>();
		String exceptionMessage = exception.getMessage();
		
		if (exceptionMessage != null) {
			StringTokenizer tokenizer = new StringTokenizer(exceptionMessage, "\n\r");
			while(tokenizer.hasMoreElements()) {
				String line = tokenizer.nextToken();
				Status status = new Status(IStatus.ERROR, Activator.getDefault().getPluginId(), IStatus.ERROR, 
					"", new Exception(line));
				statusList.add(status);
			}
		}
		IStatus[] statusArray = statusList.toArray(new IStatus[0]);
		
		
		if(statusArray.length > 1) {
			return new MultiStatus(Activator.getDefault().getPluginId(), IStatus.ERROR,
					statusArray, message, new Exception(""));	
		} else {
			return new Status(IStatus.ERROR, Activator.getDefault().getPluginId(), IStatus.ERROR, 
					message, exception);
		}
	}
}
