package org.eclipse.swordfish.tooling.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.ResourceBundle;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.ui.templates.AbstractTemplateSection;
import org.eclipse.swordfish.tooling.ui.Activator;
import org.eclipse.swordfish.tooling.ui.helper.ErrorUtil;

public abstract class BasePluginContentWsdlWizardSection extends AbstractTemplateSection {
	
	public static final int PAGE_COUNT = 1;
	
	public static final String LOCATION = "location";
	public static final String ADDRESS = "address";
	public static final String PORT = "port";
	public static final String NS_WSDL = "http://schemas.xmlsoap.org/wsdl/";
	public static final String NS_WSDL_SOAP = NS_WSDL + "soap/";
	public static final String NS_WSDL_SOAP12 = NS_WSDL + "soap12/";
	
	protected PluginContentWsdlWizardPage page;
	
	protected abstract boolean isConsumer();
	protected abstract String getGenerationErrorMessage();
	
	@Override
	public void addPages(Wizard wizard) {
		page = new PluginContentWsdlWizardPage();
		wizard.addPage(page);
		markPagesAdded();
	}
	
	@Override
	protected void generateFiles(IProgressMonitor monitor) throws CoreException {
		super.generateFiles(monitor);

	    String pathToWsdl = page.getPathToWSDL();
		try {
			PluginContentWsdlGenerationOperation generationOperation = getWsdlGenerationOperation(
					monitor, pathToWsdl, isConsumer());
			
			String serviceURL = "http://localhost:8197/"  + generationOperation.getServiceName() + "/";
			if (generationOperation.getServiceUrl() != null) {
				serviceURL = generationOperation.getServiceUrl();
			}
			
			generateAdditionalArtifacts(monitor, generationOperation, serviceURL);
		} catch (InvocationTargetException e) {
			Throwable cause = e.getCause(); 
			IStatus status = ErrorUtil.getErrorStatus(getGenerationErrorMessage(), cause);
			throw new CoreException(status);
		} catch (InterruptedException e) {
			// do nothing
		}
	}

	private PluginContentWsdlGenerationOperation getWsdlGenerationOperation(
			IProgressMonitor monitor, String pathToWsdl, boolean isConsumer)
			throws InvocationTargetException, InterruptedException {
		monitor.setTaskName("PluginContentWsdlGenerationOperation");
		IFolder srcFolder = getSourceFolder(monitor);
		PluginContentWsdlGenerationOperation generationOperation =
			new PluginContentWsdlGenerationOperation(pathToWsdl, project, srcFolder, isConsumer);
		generationOperation.run(monitor);
		List<String> warnings = generationOperation.getWarnings();
		if (!warnings.isEmpty()) {
			StringBuilder message = new StringBuilder();
			for (String warning : warnings) {
				message.append(warning).append("\n");
			}
			ErrorDialog.openError(page.getShell(),
					null,
					null,
					new Status(IStatus.WARNING, Activator.getDefault().getPluginId(), message.toString()));
		}
		return generationOperation;
	}
	
	protected  abstract void generateAdditionalArtifacts(IProgressMonitor monitor,
			PluginContentWsdlGenerationOperation generationOperation,
			String serviceURL) throws CoreException;
	
	protected void updateModel(IProgressMonitor monitor) throws CoreException {
	}
	
	public String getUsedExtensionPoint() {
		return null;
	}
	
	protected ResourceBundle getPluginResourceBundle() {
		return Platform.getResourceBundle(Activator.getDefault().getBundle());
	}
	
	public String[] getNewFiles() {
		return new String[0];
	}
	
	public int getNumberOfWorkUnits() {
		return super.getNumberOfWorkUnits() + PAGE_COUNT;
	}
	
	public String getLabel() {
		return null;
	}

	public WizardPage getPage(int pageIndex) {
		if (pageIndex == 0) {
			return page;
		}
		return null;
	}
	
	public int getPageCount() {
		return PAGE_COUNT;
	}
}
