/*******************************************************************************
 * Copyright (c) 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.wizards.generators;

import java.io.IOException;
import java.io.InputStream;

/**
 * Provides a input stream for the environment
 */
public interface InputStreamProvider {
	
	/**
	 * Creates an input stream to read the template from
	 * @param templatePath - path of the input to be read
	 * @return a stream to read from the resource path
	 * @throws IOException if stream cannot be opened
	 */
	InputStream getInputStream(String templatePath) throws IOException;
}
