/*******************************************************************************
 * Copyright (c) 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.wizards.generators.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.osgi.util.ManifestElement;

/**
 * This class holds information about consumer projects that is needed for code generation of
 * composite services.
 */
public class ConsumerProjectInformation {
	private String projectName;
	private List<JaxWsClientInformation> clientRefs;
	private ManifestElement[] packagesToImport;
	
	public ConsumerProjectInformation() {
		super();
		clientRefs = new ArrayList<JaxWsClientInformation>();
	}
	
	public ConsumerProjectInformation(String projectName) {
		this();
		this.projectName = projectName;
	}
	
	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public List<JaxWsClientInformation> getClientRefs() {
		return clientRefs;
	}
	
	public void addClientRef(JaxWsClientInformation clientInfo){
		this.clientRefs.add(clientInfo);
	}
	
	public void addClientRefList(List<JaxWsClientInformation> clientInfoList){
		this.clientRefs.addAll(clientInfoList);
	}
	
	public ManifestElement[] getPackagesToImport() {
		return packagesToImport;
	}
	
	public void setPackagesToImport(ManifestElement[] packagesToImport) {
		this.packagesToImport = packagesToImport;
	}

	@Override
	public String toString() {
		return "ConsumerProjectInformation [clientRefs=" + Arrays.toString(clientRefs.toArray()) + ", packagesToImport="
				+ Arrays.toString(packagesToImport) + ", projectName=" + projectName + "]";
	}
	
}
