/*******************************************************************************
 * Copyright (c) 2008, 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.registry.tooling.popup.actions;

import java.io.IOException;
import java.util.Iterator;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swordfish.registry.tooling.Activator;
import org.eclipse.swordfish.registry.tooling.preferences.PreferenceConstants;

/**
 * class UploadJob
 * 
 * @author amarkevich
 */
public class UploadJob extends Job {

	private static final String JOB_NAME = "Service Registry Upload"; 
	
	private final IStructuredSelection structuredSelection;
	
	/**
	 * Constructor
	 * 
	 * @param structuredSelection - selection
	 */
	public UploadJob(IStructuredSelection structuredSelection) {
		super(JOB_NAME);
		
		this.structuredSelection = structuredSelection;
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public IStatus run(IProgressMonitor monitor) {

		IStatus status = Status.OK_STATUS;

		monitor.beginTask(JOB_NAME, structuredSelection.size());

		try {
			HttpClient httpClient = new HttpClient();
			HttpMethodRetryHandler retryhandler = new HttpMethodRetryHandler() {
				/**
				 * {@inheritDoc}
				 */
				public boolean retryMethod(final HttpMethod method, 
				        final IOException exception, 
				        int executionCount) {
					return false;
				}
			};
			final String serviceRegistryURL = Activator.getDefault().getPreferenceStore().getString(PreferenceConstants.REGISTRY_URL);
			
			Iterator selectedObjects = structuredSelection.iterator();
			while (selectedObjects.hasNext()) {
				Object element = selectedObjects.next();
				if (element instanceof IFile) {
					IFile file = (IFile) element;
					setName(JOB_NAME + ": " + file.getName());

					monitor.subTask("Processing " + file.getName());
					PutMethod putMethod = new PutMethod(serviceRegistryURL + "/" + file.getName());
					putMethod.getParams().setParameter(
							HttpMethodParams.RETRY_HANDLER, retryhandler);
					RequestEntity entity = new InputStreamRequestEntity(file.getContents());
					putMethod.setRequestEntity(entity);
					try {
						int statusCode = httpClient.executeMethod(putMethod);
			            if (statusCode != HttpStatus.SC_OK) {
							status =
								new Status(IStatus.ERROR, Activator.getId(), "Error in Service Registry Upload: [" + statusCode + "] " + putMethod.getStatusText());
			            	break;
			            }
	
			            status =
							new Status(IStatus.INFO, Activator.getId(), "Response from the Registry: " + putMethod.getResponseBodyAsString());
						Activator.getDefault().getLog().log(status);
					} finally {
						// Release the connection.
			            putMethod.releaseConnection();
					}
				}

				monitor.worked(1);
			}
		} catch (Exception e) {
			status =
				new Status(IStatus.ERROR, Activator.getId(), IStatus.ERROR, e.getClass().getName() + " : " + e.getMessage(), e);
		} finally {
			monitor.done();
		}

		return status;
    }
}
