/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.filemonitor;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scanner {
    private static Log logger = LogFactory.getLog(Scanner.class);
    private long _scanInterval;
    private List<Listener> _listeners = Collections.synchronizedList(new ArrayList());
    private Map<String, Long> _prevScan = new HashMap<String, Long>();
    private FilenameFilter _filter;
    private List<File> _scanDirs;
    private volatile boolean _running = false;
    private boolean _reportExisting = true;
    private Timer _timer;
    private TimerTask _task;

    public long getScanInterval() {
        return this._scanInterval;
    }

    public synchronized void setScanInterval(long scanInterval) {
        this._scanInterval = scanInterval;
        if (this._running) {
            this.stop();
            this._timer = this.newTimer();
            this._task = this.newTimerTask();
            this.schedule(this._timer, this._task);
            this._running = true;
        }
    }

    public void setScanDir(File dir) {
        this._scanDirs = new ArrayList<File>();
        this._scanDirs.add(dir);
    }

    public File getScanDir() {
        return this._scanDirs == null ? null : this._scanDirs.get(0);
    }

    public void setScanDirs(List<File> dirs) {
        this._scanDirs = dirs;
    }

    public List<File> getScanDirs() {
        return this._scanDirs;
    }

    public void setFilenameFilter(FilenameFilter filter) {
        this._filter = filter;
    }

    public FilenameFilter getFilenameFilter() {
        return this._filter;
    }

    public void setReportExistingFilesOnStartup(boolean reportExisting) {
        this._reportExisting = reportExisting;
    }

    public synchronized void addListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.add(listener);
    }

    public synchronized void removeListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    public synchronized void start() {
        if (this._running) {
            return;
        }
        this._running = true;
        if (this._reportExisting) {
            this.scan();
        } else {
            this._prevScan = this.scanFiles();
        }
        this._timer = this.newTimer();
        this._task = this.newTimerTask();
        this.schedule(this._timer, this._task);
    }

    public TimerTask newTimerTask() {
        return new TimerTask(){

            public void run() {
                Scanner.this.scan();
            }
        };
    }

    public Timer newTimer() {
        return new Timer(true);
    }

    public void schedule(Timer timer, TimerTask task) {
        if (timer == null) {
            throw new IllegalArgumentException("Timer is null");
        }
        if (task == null) {
            throw new IllegalArgumentException("TimerTask is null");
        }
        if (this.getScanInterval() > 0L) {
            timer.scheduleAtFixedRate(task, this.getScanInterval(), this.getScanInterval());
        }
    }

    public synchronized void stop() {
        if (this._running) {
            this._running = false;
            this._timer.cancel();
            this._task.cancel();
            this._task = null;
            this._timer = null;
        }
    }

    public void scan() {
        Map<String, Long> currentScan = this.scanFiles();
        this.reportDifferences(currentScan, this._prevScan);
        this._prevScan = currentScan;
    }

    public Map<String, Long> scanFiles() {
        if (this._scanDirs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> scanInfo = new HashMap<String, Long>();
        for (File dir : this._scanDirs) {
            if (dir == null || !dir.exists()) continue;
            this.scanFile(dir, scanInfo);
        }
        return scanInfo;
    }

    public void reportDifferences(Map<String, Long> currentScan, Map<String, Long> oldScan) {
        ArrayList<String> bulkChanges = new ArrayList<String>();
        HashSet<String> oldScanKeys = new HashSet<String>(oldScan.keySet());
        for (Map.Entry<String, Long> entry : currentScan.entrySet()) {
            if (!oldScanKeys.contains(entry.getKey())) {
                logger.debug((Object)("File added: " + entry.getKey()));
                this.reportAddition(entry.getKey());
                bulkChanges.add(entry.getKey());
                continue;
            }
            if (!oldScan.get(entry.getKey()).equals(entry.getValue())) {
                logger.debug((Object)("File changed: " + entry.getKey()));
                this.reportChange(entry.getKey());
                oldScanKeys.remove(entry.getKey());
                bulkChanges.add(entry.getKey());
                continue;
            }
            oldScanKeys.remove(entry.getKey());
        }
        if (!oldScanKeys.isEmpty()) {
            for (String filename : oldScanKeys) {
                logger.debug((Object)("File removed: " + filename));
                this.reportRemoval(filename);
                bulkChanges.add(filename);
            }
        }
        if (!bulkChanges.isEmpty()) {
            this.reportBulkChanges(bulkChanges);
        }
    }

    private void scanFile(File f, Map<String, Long> scanInfoMap) {
        try {
            if (!f.exists()) {
                return;
            }
            if (f.isFile()) {
                if (this._filter == null || this._filter != null && this._filter.accept(f.getParentFile(), f.getName())) {
                    String name = f.getCanonicalPath();
                    long lastModified = f.lastModified();
                    scanInfoMap.put(name, new Long(lastModified));
                }
            } else if (f.isDirectory()) {
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.scanFile(files[i], scanInfoMap);
                }
            }
        }
        catch (IOException e) {
            logger.warn((Object)"Error scanning watched files", (Throwable)e);
        }
    }

    private void reportAddition(String filename) {
        Iterator<Listener> itor = this._listeners.iterator();
        while (itor.hasNext()) {
            try {
                Listener l = itor.next();
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileAdded(filename);
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
            catch (Error e) {
                logger.warn((Object)e);
            }
        }
    }

    private void reportRemoval(String filename) {
        Iterator<Listener> itor = this._listeners.iterator();
        while (itor.hasNext()) {
            try {
                Listener l = itor.next();
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileRemoved(filename);
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
            catch (Error e) {
                logger.warn((Object)e);
            }
        }
    }

    private void reportChange(String filename) {
        Iterator<Listener> itor = this._listeners.iterator();
        while (itor.hasNext()) {
            try {
                Listener l = itor.next();
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileChanged(filename);
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
            catch (Error e) {
                logger.warn((Object)e);
            }
        }
    }

    private void reportBulkChanges(List<String> filenames) {
        Iterator<Listener> itor = this._listeners.iterator();
        while (itor.hasNext()) {
            try {
                Listener l = itor.next();
                if (!(l instanceof BulkListener)) continue;
                ((BulkListener)l).filesChanged(filenames);
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
            catch (Error e) {
                logger.warn((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Long> getLastScanResults() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        Map<String, Long> map = this._prevScan;
        synchronized (map) {
            result.putAll(this._prevScan);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLastScanResults(Map<String, Long> results) {
        Map<String, Long> map = this._prevScan;
        synchronized (map) {
            this._prevScan.clear();
            this._prevScan.putAll(results);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BulkListener
    extends Listener {
        public void filesChanged(List<String> var1) throws Exception;
    }

    public static interface DiscreteListener
    extends Listener {
        public void fileChanged(String var1) throws Exception;

        public void fileAdded(String var1) throws Exception;

        public void fileRemoved(String var1) throws Exception;
    }

    public static interface Listener {
    }
}

