/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.soap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.DeferredConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.builder.jaxb.JaxbAssertion;
import org.apache.cxf.ws.rm.Identifier;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.RetransmissionCallback;
import org.apache.cxf.ws.rm.RetransmissionQueue;
import org.apache.cxf.ws.rm.SequenceType;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.policy.PolicyUtils;
import org.apache.cxf.ws.rm.policy.RMAssertion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetransmissionQueueImpl
implements RetransmissionQueue {
    private static final Logger LOG = LogUtils.getL7dLogger(RetransmissionQueueImpl.class);
    private Map<String, List<ResendCandidate>> candidates = new HashMap<String, List<ResendCandidate>>();
    private Resender resender;
    private RMManager manager;

    public RetransmissionQueueImpl(RMManager m) {
        this.manager = m;
    }

    public RMManager getManager() {
        return this.manager;
    }

    public void setManager(RMManager m) {
        this.manager = m;
    }

    @Override
    public void addUnacknowledged(Message message) {
        this.cacheUnacknowledged(message);
    }

    @Override
    public synchronized int countUnacknowledged(SourceSequence seq) {
        List<ResendCandidate> sequenceCandidates = this.getSequenceCandidates(seq);
        return sequenceCandidates == null ? 0 : sequenceCandidates.size();
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.getUnacknowledged().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeAcknowledged(SourceSequence seq) {
        RMStore store;
        ArrayList<BigInteger> purged = new ArrayList<BigInteger>();
        RetransmissionQueueImpl retransmissionQueueImpl = this;
        synchronized (retransmissionQueueImpl) {
            LOG.fine("Start purging resend candidates.");
            List<ResendCandidate> sequenceCandidates = this.getSequenceCandidates(seq);
            if (null != sequenceCandidates) {
                for (int i = sequenceCandidates.size() - 1; i >= 0; --i) {
                    ResendCandidate candidate = sequenceCandidates.get(i);
                    RMProperties properties = RMContextUtils.retrieveRMProperties(candidate.getMessage(), true);
                    SequenceType st = properties.getSequence();
                    BigInteger m = st.getMessageNumber();
                    if (!seq.isAcknowledged(m)) continue;
                    sequenceCandidates.remove(i);
                    candidate.resolved();
                    purged.add(m);
                }
            }
            LOG.fine("Completed purging resend candidates.");
        }
        if (purged.size() > 0 && null != (store = this.manager.getStore())) {
            store.removeMessages(seq.getIdentifier(), purged, true);
        }
    }

    @Override
    public void start() {
        if (null != this.resender) {
            return;
        }
        LOG.fine("Starting retransmission queue");
        this.resender = this.getDefaultResender();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(SourceSequence seq) {
        RetransmissionQueueImpl retransmissionQueueImpl = this;
        synchronized (retransmissionQueueImpl) {
            List<ResendCandidate> sequenceCandidates = this.getSequenceCandidates(seq);
            if (null != sequenceCandidates) {
                for (int i = sequenceCandidates.size() - 1; i >= 0; --i) {
                    ResendCandidate candidate = sequenceCandidates.get(i);
                    candidate.cancel();
                }
                LOG.log(Level.FINE, "Cancelled resends for sequence {0}.", seq.getIdentifier().getValue());
            }
        }
    }

    void stop() {
    }

    protected int getExponentialBackoff() {
        return 2;
    }

    protected ResendCandidate createResendCandidate(Message message) {
        return new ResendCandidate(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResendCandidate cacheUnacknowledged(Message message) {
        RMProperties rmps = RMContextUtils.retrieveRMProperties(message, true);
        SequenceType st = rmps.getSequence();
        Identifier sid = st.getIdentifier();
        String key = sid.getValue();
        ResendCandidate candidate = null;
        RetransmissionQueueImpl retransmissionQueueImpl = this;
        synchronized (retransmissionQueueImpl) {
            List<ResendCandidate> sequenceCandidates = this.getSequenceCandidates(key);
            if (null == sequenceCandidates) {
                sequenceCandidates = new ArrayList<ResendCandidate>();
                this.candidates.put(key, sequenceCandidates);
            }
            candidate = new ResendCandidate(message);
            sequenceCandidates.add(candidate);
        }
        LOG.fine("Cached unacknowledged message.");
        return candidate;
    }

    protected Map<String, List<ResendCandidate>> getUnacknowledged() {
        return this.candidates;
    }

    protected List<ResendCandidate> getSequenceCandidates(SourceSequence seq) {
        return this.getSequenceCandidates(seq.getIdentifier().getValue());
    }

    protected List<ResendCandidate> getSequenceCandidates(String key) {
        return this.candidates.get(key);
    }

    private void clientResend(Message message) {
        Conduit c = message.getExchange().getConduit(message);
        this.resend(c, message);
    }

    private void serverResend(Message message) {
        AddressingPropertiesImpl maps = RMContextUtils.retrieveMAPs(message, false, true);
        AttributedURIType to = null;
        if (null != maps) {
            to = maps.getTo();
        }
        if (null == to) {
            LOG.log(Level.SEVERE, "NO_ADDRESS_FOR_RESEND_MSG");
            return;
        }
        final String address = to.getValue();
        LOG.fine("Resending to address: " + address);
        final Endpoint reliableEndpoint = this.manager.getReliableEndpoint(message).getEndpoint();
        DeferredConduitSelector cs = new DeferredConduitSelector(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized Conduit selectConduit(Message message) {
                Conduit conduit = null;
                EndpointInfo endpointInfo = reliableEndpoint.getEndpointInfo();
                EndpointReferenceType original = endpointInfo.getTarget();
                try {
                    if (null != address) {
                        endpointInfo.setAddress(address);
                    }
                    conduit = super.selectConduit(message);
                }
                finally {
                    endpointInfo.setAddress(original);
                }
                return conduit;
            }
        };
        cs.setEndpoint(reliableEndpoint);
        Conduit c = cs.selectConduit(message);
        c.setMessageObserver(new MessageObserver(){

            public void onMessage(Message message) {
                LOG.fine("Ignoring response to resent message.");
            }
        });
        this.resend(c, message);
    }

    private void resend(Conduit c, Message message) {
        try {
            byte[] content;
            OutputStream os = message.getContent(OutputStream.class);
            List<CachedOutputStreamCallback> callbacks = null;
            if (os instanceof CachedOutputStream) {
                callbacks = ((CachedOutputStream)os).getCallbacks();
            }
            c.prepare(message);
            os = message.getContent(OutputStream.class);
            if (null != callbacks && callbacks.size() > 1) {
                if (!(os instanceof CachedOutputStream)) {
                    os = RMUtils.createCachedStream(message, os);
                }
                for (CachedOutputStreamCallback cb : callbacks) {
                    if (cb instanceof RetransmissionCallback) continue;
                    ((CachedOutputStream)os).registerCallback(cb);
                }
            }
            if (null == (content = (byte[])message.get("org.apache.cxf.ws.rm.content"))) {
                content = message.getContent(byte[].class);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Using saved byte array: " + content);
                }
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Using saved output stream: " + IOUtils.newStringFromBytes(content));
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(content);
            IOUtils.copyAndCloseInput(bis, os);
            os.flush();
            os.close();
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "RESEND_FAILED_MSG", ex);
        }
    }

    protected final Resender getDefaultResender() {
        return new Resender(){

            public void resend(Message message, boolean requestAcknowledge) {
                RMProperties properties = RMContextUtils.retrieveRMProperties(message, true);
                SequenceType st = properties.getSequence();
                if (st != null) {
                    LOG.log(Level.INFO, "RESEND_MSG", st.getMessageNumber());
                }
                try {
                    if (MessageUtils.isRequestor(message)) {
                        RetransmissionQueueImpl.this.clientResend(message);
                    } else {
                        RetransmissionQueueImpl.this.serverResend(message);
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "RESEND_FAILED_MSG", e);
                }
            }
        };
    }

    protected void replaceResender(Resender replacement) {
        this.resender = replacement;
    }

    protected JaxbAssertion<RMAssertion> getAssertion(AssertionInfo ai) {
        return (JaxbAssertion)ai.getAssertion();
    }

    protected class ResendCandidate
    implements Runnable {
        private Message message;
        private Date next;
        private TimerTask nextTask;
        private int resends;
        private long nextInterval;
        private long backoff;
        private boolean pending;
        private boolean includeAckRequested;

        protected ResendCandidate(Message m) {
            this.message = m;
            this.resends = 0;
            RMAssertion rma = PolicyUtils.getRMAssertion(RetransmissionQueueImpl.this.manager.getRMAssertion(), this.message);
            long baseRetransmissionInterval = rma.getBaseRetransmissionInterval().getMilliseconds().longValue();
            this.backoff = null != rma.getExponentialBackoff() ? 2L : 1L;
            this.next = new Date(System.currentTimeMillis() + baseRetransmissionInterval);
            this.nextInterval = baseRetransmissionInterval * this.backoff;
            if (null != RetransmissionQueueImpl.this.manager.getTimer()) {
                this.schedule();
            }
        }

        protected void initiate(boolean requestAcknowledge) {
            this.includeAckRequested = requestAcknowledge;
            this.pending = true;
            Endpoint ep = this.message.getExchange().get(Endpoint.class);
            Executor executor = ep.getExecutor();
            if (null == executor) {
                executor = ep.getService().getExecutor();
                LOG.log(Level.FINE, "Using service executor {0}", executor.getClass().getName());
            } else {
                LOG.log(Level.FINE, "Using endpoint executor {0}", executor.getClass().getName());
            }
            try {
                executor.execute(this);
            }
            catch (RejectedExecutionException ex) {
                LOG.log(Level.SEVERE, "RESEND_INITIATION_FAILED_MSG", ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (this.isPending()) {
                    RetransmissionQueueImpl.this.resender.resend(this.message, this.includeAckRequested);
                    this.includeAckRequested = false;
                }
            }
            finally {
                this.attempted();
            }
        }

        protected int getResends() {
            return this.resends;
        }

        protected Date getNext() {
            return this.next;
        }

        protected synchronized boolean isPending() {
            return this.pending;
        }

        protected synchronized void resolved() {
            this.pending = false;
            this.next = null;
            if (null != this.nextTask) {
                this.nextTask.cancel();
            }
        }

        protected void cancel() {
            if (null != this.nextTask) {
                this.nextTask.cancel();
            }
        }

        protected Message getMessage() {
            return this.message;
        }

        protected synchronized void attempted() {
            this.pending = false;
            ++this.resends;
            if (null != this.next) {
                this.next = new Date(this.next.getTime() + this.nextInterval);
                this.nextInterval *= this.backoff;
                this.schedule();
            }
        }

        protected final synchronized void schedule() {
            if (null == RetransmissionQueueImpl.this.manager.getTimer()) {
                return;
            }
            class ResendTask
            extends TimerTask {
                ResendCandidate candidate;

                ResendTask(ResendCandidate c) {
                    this.candidate = c;
                }

                public void run() {
                    if (!this.candidate.isPending()) {
                        this.candidate.initiate(ResendCandidate.this.includeAckRequested);
                    }
                }
            }
            this.nextTask = new ResendTask(this);
            try {
                RetransmissionQueueImpl.this.manager.getTimer().schedule(this.nextTask, this.next);
            }
            catch (IllegalStateException ex) {
                LOG.log(Level.WARNING, "SCHEDULE_RESEND_FAILED_MSG", ex);
            }
        }
    }

    public static interface Resender {
        public void resend(Message var1, boolean var2);
    }
}

