/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver.backend.base;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.configuration.ConfigurationConsumer;
import org.eclipse.swordfish.core.resolver.registry.EndpointDocumentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocumentProvider
implements EndpointDocumentProvider,
ConfigurationConsumer<Object> {
    private static final Log LOG = LogFactory.getLog(AbstractDocumentProvider.class);
    private static final String PRIORITY_PROPERTY = "priority";
    private int priority;

    public void onReceiveConfiguration(Map<String, Object> configuration) {
        if (configuration == null) {
            return;
        }
        if (configuration.containsKey(PRIORITY_PROPERTY)) {
            try {
                this.setPriority(Integer.parseInt((String)configuration.get(PRIORITY_PROPERTY)));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Document provider priority has been set to: " + this.getPriority()));
                }
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Couldn't initialize Swordfish registry proxy: malformed priority value specified", (Throwable)e);
                throw new IllegalArgumentException("Couldn't initialize Swordfish registry proxy: malformed priority value specified", e);
            }
        }
    }

    public String getId() {
        return this.getClass().getName();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }
}

