/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver.policy.helpers;

import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.PolicyBuilderImpl;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertionBuilder;
import org.apache.cxf.ws.policy.builder.xml.XMLPrimitiveAssertionBuilder;
import org.apache.neethi.Policy;
import org.eclipse.swordfish.core.resolver.policy.builder.PlatformPolicyBuilder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsPolicyBuilder
implements PlatformPolicyBuilder<Policy>,
InitializingBean {
    private static final Log LOG = LogFactory.getLog(WsPolicyBuilder.class);
    private PolicyBuilderImpl policyBuilder;
    private PrimitiveAssertionBuilder assertionBuilder;
    private boolean isInitialized = false;

    @Override
    public synchronized Policy buildPolicy(Element element) throws Exception {
        return this.policyBuilder.getPolicy(element);
    }

    @Override
    public synchronized Policy buildPolicy(InputStream stream) throws Exception {
        return this.policyBuilder.getPolicy(stream);
    }

    @Override
    public synchronized void registerPolicyAssertions(Collection<QName> assertions) {
        LinkedList<QName> assertionsToRegister = new LinkedList<QName>();
        LinkedList assertionsToUnregister = new LinkedList();
        if (this.assertionBuilder == null) {
            this.assertionBuilder = new XMLPrimitiveAssertionBuilder();
        } else {
            assertionsToUnregister.addAll(this.assertionBuilder.getKnownElements());
            assertionsToUnregister.removeAll(assertions);
        }
        assertionsToRegister.addAll(assertions);
        this.assertionBuilder.setKnownElements(assertionsToRegister);
        AssertionBuilderRegistry builderRegistry = this.policyBuilder.getAssertionBuilderRegistry();
        builderRegistry.setIgnoreUnknownAssertions(false);
        for (QName elem : assertionsToUnregister) {
            builderRegistry.unregister((Object)elem);
        }
        for (QName elem : assertionsToRegister) {
            builderRegistry.register((Object)elem, (Object)this.assertionBuilder);
        }
    }

    @Override
    public synchronized void setPolicyNamespace(String namespace) {
        if (!this.isInitialized) {
            PolicyConstants constants = new PolicyConstants();
            constants.setNamespace(namespace);
            this.policyBuilder.getBus().setExtension((Object)constants, PolicyConstants.class);
            this.isInitialized = true;
        } else {
            ((PolicyConstants)this.policyBuilder.getBus().getExtension(PolicyConstants.class)).setNamespace(namespace);
        }
    }

    public synchronized void setPolicyBuilder(PolicyBuilderImpl policyBuilder) {
        this.policyBuilder = policyBuilder;
        this.isInitialized = false;
    }

    public PolicyBuilderImpl getPolicyBuilder() {
        return this.policyBuilder;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.policyBuilder, (String)"Platform policy builder must be set");
    }
}

