/*******************************************************************************
 * Copyright (c) 2008, 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/**
 * class Logger - used for logging into Error Log view
 * 
 * @author amarkevich
 */
public class Logger {

	private Logger() {
	}

	/**
	 * Logs the given status
	 * 
	 * @param status Status
	 */
	public static void log(IStatus status) {
		Activator.getDefault().getLog().log(status);
	}

	/**
	 * Logs the given error message
	 * 
	 * @param message Message
	 */
	public static void error(String message) {
		log(new Status(IStatus.ERROR, Activator.getDefault().getPluginId(), IStatus.ERROR, message, null));
	}

	/**
	 * Logs the given exception
	 * 
	 * @param e Throwable
	 */
	public static void error(Throwable e) {
		log(new Status(IStatus.ERROR, Activator.getDefault().getPluginId(), IStatus.ERROR, getMessage(e), e));
	}

	/**
	 * Logs the given exception
	 * 
	 * @param message Message
	 * @param e Throwable
	 */
	public static void error(String message, Throwable e) {
		log(new Status(IStatus.ERROR, Activator.getDefault().getPluginId(), IStatus.ERROR, message, e));
	}

	/**
	 * Logs the given warning message
	 * 
	 * @param message Message
	 */
	public static void warn(String message) {
		log(new Status(IStatus.WARNING, Activator.getDefault().getPluginId(), IStatus.WARNING, message, null));
	}

	/**
	 * Returns the detail message string of this throwable.
	 * 
	 * @param e Throwable
	 * @return detail message string of this throwable
	 */
	public static String getMessage(Throwable e) {
		return (e.getMessage() != null) ? e.getMessage() : e.getClass().getName();
	}

}
