/*******************************************************************************
 * Copyright (c) 2008, 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.helper;

import java.util.List;

import org.apache.cxf.helpers.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * The utility class that extracts important info from the wsdl dom document
 *
 */
public class WsdlSupport {
	
	/**
	 * @param document - wsdl document
	 * @return the target highest level namespace of the wsdl
	 */
	public static String getTargetNameSpace(Document document) {		
		return document.getDocumentElement().getAttribute("targetNamespace");		
	}
	
	/**
	 * @param document - wsdl document
	 * @return the serviceUrl within the soap:address element if present
	 */
	public static String getServiceUrl(Document document) {		
		String ret = null;
		List<Element>elementList = DOMUtils.findAllElementsByTagNameNS(document.getDocumentElement(), "http://schemas.xmlsoap.org/wsdl/", "port");
		for (Element el : elementList) {
		     Element soapAddress =  DOMUtils.findAllElementsByTagNameNS(
			    			  el, "http://schemas.xmlsoap.org/wsdl/soap/", "address")
			    			  .iterator().next();
		     ret = soapAddress.getAttribute("location");
         }
		return ret;
	}
	
	/**
	 * @param document - wsdl document
	 * @return the serviceName wsdl:service element if present
	 */
	public static String getServiceName(Document document) {
		List<Element> elementList = DOMUtils.findAllElementsByTagNameNS(document.getDocumentElement(), "http://schemas.xmlsoap.org/wsdl/", "service");
		String ret = null;
		if (elementList.size() > 0) {
			ret = elementList.get(0).getAttribute("name");
		}
		return ret;
	}
	/**
	 * @param document - wsdl document
	 * @return the portName wsdl:port element if present
	 */
	public static String getPortName(Document document) {
		List<Element> elementList = DOMUtils.findAllElementsByTagNameNS(document.getDocumentElement(), "http://schemas.xmlsoap.org/wsdl/", "port");
		String ret = null;
		if (elementList.size() > 0) {
			ret = elementList.get(0).getAttribute("name");
		}
		return ret;
	}
}
