/*******************************************************************************
 * Copyright (c) 2008, 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.ui.templates.ITemplateSection;

/**
 * class PluginContentConsumerWsdlWizard
 * 
 * @author amarkevich
 */
public class PluginContentConsumerWsdlWizard extends PluginContentWsdlWizard {

	private static final IPluginReference[] DEPENDENCIES = {
		//new PluginReference("javax.xml.bind", null, 0),
	};

	private static final String[] IMPORT_PACKAGES = {
		"javax.xml.stream",
		"com.sun.xml.bind.v2",
		"javax.activation",
		"javax.annotation",
		"org.apache.xml.resolver",
		"org.apache.ws.commons.schema.utils",
		"javax.xml.soap",
		"com.ctc.wstx.stax",
		"org.apache.commons.logging",
		"org.springframework.beans.factory",
		"org.springframework.util"
	};
	
	@Override
	public ITemplateSection[] createTemplateSections() {
        return new ITemplateSection[] { new PluginContentConsumerWsdlWizardSection() };
	}

	@Override
	public IPluginReference[] getDependencies(String schemaVersion) {
		List<IPluginReference> pluginReferences = new ArrayList<IPluginReference>(Arrays.asList(super.getDependencies(schemaVersion)));
		pluginReferences.addAll(Arrays.asList(DEPENDENCIES));
		return pluginReferences.toArray(new IPluginReference[pluginReferences.size()]);
	}

	@Override
	public String[] getImportPackages() {
		List<String> pluginImportPackages = new ArrayList<String>(Arrays.asList(super.getImportPackages()));
		pluginImportPackages.addAll(Arrays.asList(IMPORT_PACKAGES));
		return pluginImportPackages.toArray(new String[pluginImportPackages.size()]);
	}
}
