/*******************************************************************************
 * Copyright (c) 2008, 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.wizards;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.swordfish.tooling.ui.Messages;
import org.eclipse.swordfish.tooling.ui.helper.ConsumerProjectInformationUtil;
import org.eclipse.swordfish.tooling.ui.wizards.actions.GenerationJob;
import org.eclipse.swordfish.tooling.ui.wizards.actions.ProviderServiceManipulationJob;
import org.eclipse.swordfish.tooling.ui.wizards.generators.CodeGenerator;
import org.eclipse.swordfish.tooling.ui.wizards.generators.CxfProviderSpringEndpointGenerator;
import org.eclipse.swordfish.tooling.ui.wizards.generators.JaxWsClientReferenceGenerator;
import org.eclipse.swordfish.tooling.ui.wizards.generators.JaxWsSpringReferenceGenerator;
import org.eclipse.swordfish.tooling.ui.wizards.generators.data.ConsumerProjectInformation;

/**
 * class PluginContentWsdlWizardSection
 * 
 * @author amarkevich
 */
public class PluginContentWsdlWizardSection extends
		BasePluginContentWsdlWizardSection {
	public static final String CXF_ENDPOINT_FILENAME = "META-INF/spring/cxf-endpoint.xml";
	private CompositeServiceWizardPage compositeServicePage;

	public void addPages(Wizard wizard) {
		page = new PluginContentWsdlWizardPage();
		wizard.addPage(page);

		compositeServicePage = new CompositeServiceWizardPage();
		page.setNextPage(compositeServicePage);
		wizard.addPage(compositeServicePage);

		markPagesAdded();
	}

	protected void generateAdditionalArtifacts(IProgressMonitor monitor,
			PluginContentWsdlGenerationOperation generationOperation,
			String serviceURL) throws CoreException {
		monitor.setTaskName("CxfEndpointGenerationJob");
		IPath path = project.getFullPath().append(CXF_ENDPOINT_FILENAME);

		List<ConsumerProjectInformation> consumerInfo = getConsumerProjectInfo();
		String clientRefs = new JaxWsClientReferenceGenerator().generate(consumerInfo);
		String springRefs = new JaxWsSpringReferenceGenerator().generate(consumerInfo);

		CodeGenerator providerSpringGen = new CxfProviderSpringEndpointGenerator(
				generationOperation.getServiceName(), generationOperation.getNameSpace(), 
				generationOperation.getImplementorName(), serviceURL, clientRefs,
				springRefs);
		GenerationJob cxfEndpointJob = new GenerationJob(providerSpringGen,	path);
		IStatus result = cxfEndpointJob.runInWorkspace(monitor);

		if (result.isOK()) {
			if (consumerInfo.size() > 0) {
//				project.build(IncrementalProjectBuilder.INCREMENTAL_BUILD, monitor);
				ProviderServiceManipulationJob mani = 
					new ProviderServiceManipulationJob(project, generationOperation.getImplementorName(), consumerInfo);
				result = mani.runInWorkspace(monitor);
			}
		}

		if (!result.isOK()) {
			throw new CoreException(result);
		}
	}

	
	/**
	 * Get a list of all imports needed for the selected consumer projects
	 * 
	 * @return a list of manifest elements of the exports of the selected consumer projects
	 */
	List<ManifestElement> getConsumerImports() {
		List<ManifestElement> imports = new ArrayList<ManifestElement>();

		for (ConsumerProjectInformation proInf : getConsumerProjectInfo()) {
			ManifestElement[] toImport = proInf.getPackagesToImport();

			if (toImport != null) {
				for (ManifestElement entry : toImport) {
					imports.add(entry);
				}
			}
		}

		return imports;
	}

	/**
	 * Get the information about consumer projects from the list of all selected projects
	 * 
	 * @return A list of ConsumerProjectInformation objects of all selected projects
	 */
	private List<ConsumerProjectInformation> getConsumerProjectInfo() {
		IProject[] projects = compositeServicePage.getSelectedConsumerProjects();
		List<ConsumerProjectInformation> infoList = new ArrayList<ConsumerProjectInformation>();

		for (IProject project : projects) {
			ConsumerProjectInformation info = ConsumerProjectInformationUtil.getConsumerProjectInfo(project);
			infoList.add(info);
		}
		return infoList;
	}

	protected boolean isConsumer() {
		return false;
	}

	protected String getGenerationErrorMessage() {
		return Messages.ERROR_JAXWS_PROVIDER_GENERATION;
	}

	public int getPageCount() {
		return 2;
	}

}
