/*******************************************************************************
 * Copyright (c) 2008, 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.wizards.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swordfish.tooling.ui.Activator;
import org.eclipse.swordfish.tooling.ui.wizards.generators.CodeGenerator;
import org.eclipse.ui.ide.undo.CreateFileOperation;

/**
 * IRunnableWithProgress implementation intended to become entry point for cxf-endpoint generation used in all tools,
 * that need to.
 * 
 * @author yyurkin
 * 
 */
public class GenerationJob extends WorkspaceJob {
	private IPath filePath;
	private CodeGenerator generator;

	/**
	 * The constructor.
	 * 
	 * @param generator - a generator to do the processing
	 * @param filePath - the path in workspace to save the generated code to
	 */
	public GenerationJob(CodeGenerator generator, IPath filePath) {
		super("CXF code generation");
		this.generator = generator;
		this.filePath = filePath;
	}

	@Override
	public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
		try {
			final IFile newFileHandle = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
			CreateFileOperation op = new CreateFileOperation(newFileHandle, null, generator.generate(), "File creation");
			op.execute(monitor, null);

		} catch (Exception e) {
			return new Status(IStatus.ERROR, Activator.getDefault().getPluginId(), IStatus.ERROR, e.getClass()
					.getName()
					+ " : " + e.getMessage(), e);
		}
		return Status.OK_STATUS;
	}
}