package org.eclipse.swordfish.tooling.ui.wizards.generators;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.swordfish.tooling.ui.Logger;
import org.eclipse.swordfish.tooling.ui.helper.TemplateProcessor;
import org.eclipse.swordfish.tooling.ui.wizards.TemplateConstants;

public class CxfConsumerClientInvokerGenerator implements CodeGenerator {
	private static final String TEMPLATE_CLIENT_INVOKER = "/templates/consumer/java/ClientInvoker.java"; //$NON-NLS-1$
	private String implementor;
	private InputStreamProvider templateProvider;

	/**
	 * Create new generator instance
	 * @param serviceImplementor - the fully qualified class name of the service implementor (port type name)
	 */
	public CxfConsumerClientInvokerGenerator(String serviceImplementor) {
		this.implementor = serviceImplementor;
		this.templateProvider = new DefaultTemplateStreamProvider();
	}

	public InputStream generate() {
		InputStream template = null;
		InputStream result = null;
		try {
			template = templateProvider.getInputStream(TEMPLATE_CLIENT_INVOKER);
			Map<String, String> replacements = new HashMap<String, String>();

			int index = implementor.lastIndexOf('.');
			replacements.put(TemplateConstants.KEY_SERVICE_PACKAGE, implementor.substring(0, index) + ".sample");
			replacements.put("serviceClientPackage", implementor.substring(0, index));

			String serviceImpl = implementor.substring(index + 1);
			replacements.put(TemplateConstants.KEY_SERVICE_IMPL, serviceImpl);

			replacements.put(TemplateConstants.KEY_SERVICE_IMPL_INSTANCE, deCaptitalize(serviceImpl));
			result = new TemplateProcessor(template, replacements).process();

		} catch (IOException ioe) {
			Logger.error("Unable to process template", ioe);

		} finally {
			if (template != null) {
				try {
					template.close();
				} catch (IOException ioe2) {
					// ignore
				}
			}
		}
		return result;
	}

	private String deCaptitalize(String str) {
		return str.substring(0, 1).toLowerCase() + str.substring(1);
	}


	/* (non-Javadoc)
	 * @see org.eclipse.swordfish.tooling.ui.wizards.generators.CodeGenerator#setTemplateStreamProvider(org.eclipse.swordfish.tooling.ui.wizards.generators.InputStreamProvider)
	 */
	public void setTemplateStreamProvider(InputStreamProvider templateProvider) {
		this.templateProvider = templateProvider;
	}
}
