/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.event;

import java.util.Dictionary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.event.Event;
import org.eclipse.swordfish.core.event.EventService;
import org.eclipse.swordfish.internal.core.util.OrderPreservingDictionary;
import org.osgi.service.event.EventAdmin;
import org.springframework.util.Assert;

public class EventServiceImpl
implements EventService {
    private static final Log LOG = LogFactory.getLog(EventServiceImpl.class);
    private EventAdmin eventAdmin;

    public EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void postEvent(Event swordfishEvent) {
        LOG.debug((Object)("Sending event to topic [" + swordfishEvent.getTopic() + "]"));
        Assert.notNull((Object)swordfishEvent.getTopic(), (String)"The destination topic must be supplied");
        Assert.notNull((Object)this.eventAdmin, (String)"The EventAdmin service must be supplied");
        OrderPreservingDictionary properties = new OrderPreservingDictionary(swordfishEvent.getProperties());
        properties.put("event", swordfishEvent);
        org.osgi.service.event.Event event = new org.osgi.service.event.Event(swordfishEvent.getTopic(), (Dictionary)properties);
        this.eventAdmin.postEvent(event);
    }
}

