/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxf.binding.nmr;

import javax.xml.namespace.QName;
import org.apache.cxf.binding.AbstractBindingFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.servicemix.cxf.binding.nmr.NMRBinding;
import org.apache.servicemix.cxf.binding.nmr.NMRBindingInfo;
import org.apache.servicemix.cxf.binding.nmr.interceptors.NMRFaultInInterceptor;
import org.apache.servicemix.cxf.binding.nmr.interceptors.NMRFaultOutInterceptor;
import org.apache.servicemix.cxf.binding.nmr.interceptors.NMROperationInInterceptor;
import org.apache.servicemix.cxf.binding.nmr.interceptors.NMRWrapperInInterceptor;
import org.apache.servicemix.cxf.binding.nmr.interceptors.NMRWrapperOutInterceptor;

public class NMRBindingFactory
extends AbstractBindingFactory {
    public Binding createBinding(BindingInfo binding) {
        NMRBinding jb = new NMRBinding((NMRBindingInfo)binding);
        jb.getInInterceptors().add(new StaxInInterceptor());
        jb.getInInterceptors().add(new NMROperationInInterceptor());
        jb.getInInterceptors().add(new NMRWrapperInInterceptor());
        jb.getOutInterceptors().add(new StaxOutInterceptor());
        jb.getOutInterceptors().add(new NMRWrapperOutInterceptor());
        jb.getOutFaultInterceptors().add(new StaxOutInterceptor());
        jb.getOutFaultInterceptors().add(new NMRFaultOutInterceptor());
        jb.getInFaultInterceptors().add(new NMRFaultInInterceptor());
        return jb;
    }

    public BindingInfo createBindingInfo(ServiceInfo service, String namespace, Object config) {
        NMRBindingInfo info = new NMRBindingInfo(service, "http://cxf.apache.org/bindings/nmr");
        info.setName(new QName(service.getName().getNamespaceURI(), service.getName().getLocalPart() + "NMRBinding"));
        for (OperationInfo op : service.getInterface().getOperations()) {
            BindingOperationInfo bop = info.buildOperation(op.getName(), op.getInputName(), op.getOutputName());
            info.addOperation(bop);
        }
        return info;
    }
}

