/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.http.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.MessageSenderInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentTypeOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    public ContentTypeOutInterceptor() {
        super("prepare-send");
        this.addBefore(MessageSenderInterceptor.class.getName());
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        String ct;
        Map headers = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
        if (headers == null) {
            headers = new HashMap();
            message.put(Message.PROTOCOL_HEADERS, headers);
        }
        if ((ct = (String)message.getExchange().get(Endpoint.class).get("Content-Type")) != null) {
            ArrayList<String> contentType = new ArrayList<String>();
            contentType.add(ct);
            headers.put(HttpHeaderHelper.getHeaderKey("Content-Type"), contentType);
            message.put("Content-Type", ct);
        }
    }
}

