/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.jaxrs.ext.MappingsHandler;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.ext.ResponseHandler;
import org.apache.cxf.jaxrs.impl.RequestPreprocessor;
import org.apache.cxf.jaxrs.impl.WebApplicationExceptionMapper;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.BinaryDataProvider;
import org.apache.cxf.jaxrs.provider.FormEncodingReaderProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.provider.JSONProvider;
import org.apache.cxf.jaxrs.provider.PrimitiveTextProvider;
import org.apache.cxf.jaxrs.provider.SourceProvider;
import org.apache.cxf.jaxrs.provider.StringProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProviderFactory {
    private static final ProviderFactory PF = new ProviderFactory();
    private List<ProviderInfo<MessageBodyReader>> defaultMessageReaders = new ArrayList<ProviderInfo<MessageBodyReader>>();
    private List<ProviderInfo<MessageBodyWriter>> defaultMessageWriters = new ArrayList<ProviderInfo<MessageBodyWriter>>();
    private List<ProviderInfo<MessageBodyReader>> userMessageReaders = new ArrayList<ProviderInfo<MessageBodyReader>>();
    private List<ProviderInfo<MessageBodyWriter>> userMessageWriters = new ArrayList<ProviderInfo<MessageBodyWriter>>();
    private List<ProviderInfo<ContextResolver>> userContextResolvers = new ArrayList<ProviderInfo<ContextResolver>>();
    private List<ProviderInfo<ExceptionMapper>> userExceptionMappers = new ArrayList<ProviderInfo<ExceptionMapper>>();
    private List<ProviderInfo<RequestHandler>> requestHandlers = new ArrayList<ProviderInfo<RequestHandler>>();
    private List<ProviderInfo<ResponseHandler>> responseHandlers = new ArrayList<ProviderInfo<ResponseHandler>>();
    private RequestPreprocessor requestPreprocessor;

    private ProviderFactory() {
        this.setProviders(this.defaultMessageReaders, this.defaultMessageWriters, this.userContextResolvers, this.requestHandlers, this.responseHandlers, this.userExceptionMappers, new JAXBElementProvider(), new JSONProvider(), new BinaryDataProvider(), new StringProvider(), new SourceProvider(), new FormEncodingReaderProvider(), new PrimitiveTextProvider(), new WebApplicationExceptionMapper(), new MappingsHandler());
    }

    public static ProviderFactory getInstance() {
        return PF;
    }

    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m) {
        for (ProviderInfo<ContextResolver> cr : this.userContextResolvers) {
            Type[] types;
            for (Type t : types = cr.getProvider().getClass().getGenericInterfaces()) {
                if (!(t instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)t;
                Type[] args = pt.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    if (contextType != args[i]) continue;
                    InjectionUtils.injectContextFields(cr.getProvider(), cr, m);
                    InjectionUtils.injectContextMethods(cr.getProvider(), cr, m);
                    return cr.getProvider();
                }
            }
        }
        return null;
    }

    public <T> ExceptionMapper<T> createExceptionMapper(Class<?> exceptionType, Message m) {
        for (ProviderInfo<ExceptionMapper> em : this.userExceptionMappers) {
            Type[] types;
            for (Type t : types = em.getProvider().getClass().getGenericInterfaces()) {
                if (!(t instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)t;
                Type[] args = pt.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    if (!((Class)args[i]).isAssignableFrom(exceptionType)) continue;
                    InjectionUtils.injectContextFields(em.getProvider(), em, m);
                    InjectionUtils.injectContextMethods(em.getProvider(), em, m);
                    return em.getProvider();
                }
            }
        }
        return null;
    }

    public <T> MessageBodyReader<T> createMessageBodyReader(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m) {
        MessageBodyReader<T> mr = this.chooseMessageReader(this.userMessageReaders, bodyType, parameterType, parameterAnnotations, mediaType, m);
        if (mr == null) {
            mr = this.chooseMessageReader(this.defaultMessageReaders, bodyType, parameterType, parameterAnnotations, mediaType, m);
        }
        return mr;
    }

    public List<ProviderInfo<RequestHandler>> getRequestHandlers() {
        return Collections.unmodifiableList(this.requestHandlers);
    }

    public List<ProviderInfo<ResponseHandler>> getResponseHandlers() {
        return Collections.unmodifiableList(this.responseHandlers);
    }

    public <T> MessageBodyWriter<T> createMessageBodyWriter(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m) {
        MessageBodyWriter<T> mw = this.chooseMessageWriter(this.userMessageWriters, bodyType, parameterType, parameterAnnotations, mediaType, m);
        if (mw == null) {
            mw = this.chooseMessageWriter(this.defaultMessageWriters, bodyType, parameterType, parameterAnnotations, mediaType, m);
        }
        return mw;
    }

    private void setProviders(List<ProviderInfo<MessageBodyReader>> readers, List<ProviderInfo<MessageBodyWriter>> writers, List<ProviderInfo<ContextResolver>> resolvers, List<ProviderInfo<RequestHandler>> requestFilters, List<ProviderInfo<ResponseHandler>> responseFilters, List<ProviderInfo<ExceptionMapper>> excMappers, Object ... providers) {
        for (Object o : providers) {
            if (MessageBodyReader.class.isAssignableFrom(o.getClass())) {
                readers.add(new ProviderInfo<MessageBodyReader>((MessageBodyReader)o));
            }
            if (MessageBodyWriter.class.isAssignableFrom(o.getClass())) {
                writers.add(new ProviderInfo<MessageBodyWriter>((MessageBodyWriter)o));
            }
            if (ContextResolver.class.isAssignableFrom(o.getClass())) {
                resolvers.add(new ProviderInfo<ContextResolver>((ContextResolver)o));
            }
            if (RequestHandler.class.isAssignableFrom(o.getClass())) {
                requestFilters.add(new ProviderInfo<RequestHandler>((RequestHandler)o));
            }
            if (ResponseHandler.class.isAssignableFrom(o.getClass())) {
                responseFilters.add(new ProviderInfo<ResponseHandler>((ResponseHandler)o));
            }
            if (!ExceptionMapper.class.isAssignableFrom(o.getClass())) continue;
            excMappers.add(new ProviderInfo<ExceptionMapper>((ExceptionMapper)o));
        }
        this.sortReaders(readers);
        this.sortWriters(writers);
        this.injectContexts(readers, writers, resolvers, requestFilters, responseFilters, excMappers);
    }

    void injectContexts(List<?> ... providerLists) {
        for (List<?> list : providerLists) {
            for (Object p : list) {
                ProviderInfo pi = (ProviderInfo)p;
                InjectionUtils.injectContextProxies(pi, pi.getProvider());
            }
        }
    }

    private void sortReaders(List<ProviderInfo<MessageBodyReader>> entityProviders) {
        Collections.sort(entityProviders, new MessageBodyReaderComparator());
    }

    private void sortWriters(List<ProviderInfo<MessageBodyWriter>> entityProviders) {
        Collections.sort(entityProviders, new MessageBodyWriterComparator());
    }

    private <T> MessageBodyReader<T> chooseMessageReader(List<ProviderInfo<MessageBodyReader>> readers, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        for (ProviderInfo<MessageBodyReader> ep : readers) {
            if (!this.matchesReaderCriterias(ep.getProvider(), type, genericType, annotations, mediaType)) continue;
            InjectionUtils.injectContextFields(ep.getProvider(), ep, m);
            InjectionUtils.injectContextMethods(ep.getProvider(), ep, m);
            return ep.getProvider();
        }
        return null;
    }

    private <T> boolean matchesReaderCriterias(MessageBodyReader<T> ep, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!ep.isReadable(type, genericType, annotations)) {
            return false;
        }
        List<MediaType> supportedMediaTypes = JAXRSUtils.getConsumeTypes(ep.getClass().getAnnotation(ConsumeMime.class));
        List<MediaType> availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), supportedMediaTypes);
        return availableMimeTypes.size() != 0;
    }

    private <T> MessageBodyWriter<T> chooseMessageWriter(List<ProviderInfo<MessageBodyWriter>> writers, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        for (ProviderInfo<MessageBodyWriter> ep : writers) {
            if (!this.matchesWriterCriterias(ep.getProvider(), type, genericType, annotations, mediaType)) continue;
            InjectionUtils.injectContextFields(ep.getProvider(), ep, m);
            InjectionUtils.injectContextMethods(ep.getProvider(), ep, m);
            return ep.getProvider();
        }
        return null;
    }

    private <T> boolean matchesWriterCriterias(MessageBodyWriter<T> ep, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!ep.isWriteable(type, genericType, annotations)) {
            return false;
        }
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProduceTypes(ep.getClass().getAnnotation(ProduceMime.class));
        List<MediaType> availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), supportedMediaTypes);
        return availableMimeTypes.size() != 0;
    }

    public boolean deregisterEntityProvide(Object o) {
        if (o instanceof MessageBodyReader) {
            return this.userMessageReaders.remove(o);
        }
        if (o instanceof MessageBodyWriter) {
            return this.userMessageWriters.remove(o);
        }
        if (o instanceof ContextResolver) {
            return this.userContextResolvers.remove(o);
        }
        if (o instanceof RequestHandler) {
            return this.requestHandlers.remove(o);
        }
        return false;
    }

    List<ProviderInfo<MessageBodyReader>> getDefaultMessageReaders() {
        return Collections.unmodifiableList(this.defaultMessageReaders);
    }

    List<ProviderInfo<MessageBodyWriter>> getDefaultMessageWriters() {
        return Collections.unmodifiableList(this.defaultMessageWriters);
    }

    List<ProviderInfo<MessageBodyReader>> getUserMessageReaders() {
        return Collections.unmodifiableList(this.userMessageReaders);
    }

    List<ProviderInfo<MessageBodyWriter>> getUserMessageWriters() {
        return Collections.unmodifiableList(this.userMessageWriters);
    }

    List<ProviderInfo<ContextResolver>> getUserContextResolvers() {
        return Collections.unmodifiableList(this.userContextResolvers);
    }

    public void registerUserProvider(Object provider) {
        this.setUserProviders(Collections.singletonList(provider));
    }

    public void setUserProviders(List<?> userProviders) {
        this.setProviders(this.userMessageReaders, this.userMessageWriters, this.userContextResolvers, this.requestHandlers, this.responseHandlers, this.userExceptionMappers, userProviders.toArray());
    }

    public void setRequestPreporcessor(RequestPreprocessor rp) {
        this.requestPreprocessor = rp;
    }

    public RequestPreprocessor getRequestPreprocessor() {
        return this.requestPreprocessor;
    }

    public void cleatThreadLocalProxies() {
        this.clearProxies(this.defaultMessageReaders, this.defaultMessageWriters, this.userMessageReaders, this.userMessageWriters, this.userContextResolvers, this.requestHandlers, this.responseHandlers, this.userExceptionMappers);
    }

    void clearProxies(List<?> ... lists) {
        for (List<?> list : lists) {
            for (Object p : list) {
                ProviderInfo pi = (ProviderInfo)p;
                pi.clearThreadLocalProxies();
            }
        }
    }

    void clearProviders() {
        this.userMessageReaders.clear();
        this.userMessageWriters.clear();
        this.userContextResolvers.clear();
        this.userExceptionMappers.clear();
        this.requestHandlers.clear();
        this.responseHandlers.clear();
    }

    public void setSchemaLocations(List<String> schemas) {
        this.setSchemasOnProviders(this.userMessageReaders, schemas);
        this.setSchemasOnProviders(this.defaultMessageReaders, schemas);
    }

    private void setSchemasOnProviders(List<ProviderInfo<MessageBodyReader>> providers, List<String> schemas) {
        for (ProviderInfo<MessageBodyReader> r : providers) {
            try {
                Method m = r.getProvider().getClass().getMethod("setSchemas", List.class);
                m.invoke((Object)r.getProvider(), schemas);
            }
            catch (Exception ex) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageBodyWriterComparator
    implements Comparator<ProviderInfo<MessageBodyWriter>> {
        private MessageBodyWriterComparator() {
        }

        @Override
        public int compare(ProviderInfo<MessageBodyWriter> p1, ProviderInfo<MessageBodyWriter> p2) {
            MessageBodyWriter e1 = p1.getProvider();
            MessageBodyWriter e2 = p2.getProvider();
            ProduceMime c = e1.getClass().getAnnotation(ProduceMime.class);
            String[] mimeType1 = new String[]{"*/*"};
            if (c != null) {
                mimeType1 = c.value();
            }
            ProduceMime c2 = e2.getClass().getAnnotation(ProduceMime.class);
            String[] mimeType2 = new String[]{"*/*"};
            if (c2 != null) {
                mimeType2 = c2.value();
            }
            return this.compareString(mimeType1[0], mimeType2[0]);
        }

        private int compareString(String str1, String str2) {
            if (!str1.startsWith("*/") && str2.startsWith("*/")) {
                return -1;
            }
            if (str1.startsWith("*/") && !str2.startsWith("*/")) {
                return 1;
            }
            return str1.compareTo(str2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageBodyReaderComparator
    implements Comparator<ProviderInfo<MessageBodyReader>> {
        private MessageBodyReaderComparator() {
        }

        @Override
        public int compare(ProviderInfo<MessageBodyReader> p1, ProviderInfo<MessageBodyReader> p2) {
            MessageBodyReader e1 = p1.getProvider();
            MessageBodyReader e2 = p2.getProvider();
            ConsumeMime c = e1.getClass().getAnnotation(ConsumeMime.class);
            String[] mimeType1 = new String[]{"*/*"};
            if (c != null) {
                mimeType1 = c.value();
            }
            ConsumeMime c2 = e2.getClass().getAnnotation(ConsumeMime.class);
            String[] mimeType2 = new String[]{"*/*"};
            if (c2 != null) {
                mimeType2 = c2.value();
            }
            return this.compareString(mimeType1[0], mimeType2[0]);
        }

        private int compareString(String str1, String str2) {
            if (!str1.startsWith("*/") && str2.startsWith("*/")) {
                return -1;
            }
            if (str1.startsWith("*/") && !str2.startsWith("*/")) {
                return 1;
            }
            return str1.compareTo(str2);
        }
    }
}

