/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.EndpointRegistry;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.core.CacheableReference;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMatchingReference
implements CacheableReference,
Serializable {
    private final Map<String, ?> properties;
    private volatile transient List<InternalEndpoint> matches;
    private transient EndpointRegistry registry;

    public PropertyMatchingReference(Map<String, ?> properties) {
        this.properties = properties;
    }

    public Iterable<InternalEndpoint> choose(EndpointRegistry registry) {
        List<InternalEndpoint> result = this.matches;
        if (this.matches == null || this.registry != registry) {
            result = new ArrayList<InternalEndpoint>();
            for (Endpoint ep : registry.query(null)) {
                InternalEndpoint iep = (InternalEndpoint)ep;
                if (Boolean.valueOf((String)iep.getMetaData().get("UNTARGETABLE")).booleanValue() || !this.match(registry, iep)) continue;
                result.add(iep);
            }
            this.registry = registry;
            this.matches = result;
        }
        return result;
    }

    protected boolean match(EndpointRegistry registry, InternalEndpoint endpoint) {
        Map epProps = registry.getProperties((Object)endpoint);
        for (Map.Entry<String, ?> name : this.properties.entrySet()) {
            if (name.getValue().equals(epProps.get(name.getKey()))) continue;
            return false;
        }
        return true;
    }

    public Document toXml() {
        return null;
    }

    @Override
    public void setDirty() {
        this.matches = null;
    }

    public String toString() {
        return "PropertyMatchingReference[" + this.properties + "]";
    }
}

