/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.core.security;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.servicemix.nmr.api.security.AuthorizationEntry;
import org.apache.servicemix.nmr.api.security.GroupPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAuthorizationEntry
implements AuthorizationEntry {
    private Set<GroupPrincipal> acls;
    private String endpoint;
    private QName operation;
    private AuthorizationEntry.Type type = AuthorizationEntry.Type.Add;
    private int rank;

    public DefaultAuthorizationEntry() {
    }

    public DefaultAuthorizationEntry(String endpoint, QName operation, String roles) {
        this.endpoint = endpoint;
        this.operation = operation;
        this.acls = this.buildRoles(roles);
    }

    public DefaultAuthorizationEntry(String endpoint, QName operation, String roles, AuthorizationEntry.Type type) {
        this.endpoint = endpoint;
        this.operation = operation;
        this.acls = this.buildRoles(roles);
        this.type = type;
    }

    public DefaultAuthorizationEntry(String endpoint, QName operation, String roles, AuthorizationEntry.Type type, int rank) {
        this.endpoint = endpoint;
        this.operation = operation;
        this.acls = this.buildRoles(roles);
        this.type = type;
        this.rank = rank;
    }

    public AuthorizationEntry.Type getType() {
        return this.type;
    }

    public void setType(AuthorizationEntry.Type type) {
        this.type = type;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public QName getOperation() {
        return this.operation;
    }

    public void setOperation(QName operation) {
        this.operation = operation;
    }

    public Set<GroupPrincipal> getAcls() {
        return this.acls;
    }

    public void setAcls(Set<GroupPrincipal> acls) {
        this.acls = acls;
    }

    public void setRoles(String roles) {
        this.acls = this.buildRoles(roles);
    }

    public String getRoles() {
        StringBuffer sb = new StringBuffer();
        if (this.acls != null) {
            Iterator<GroupPrincipal> iter = this.acls.iterator();
            while (iter.hasNext()) {
                GroupPrincipal p = iter.next();
                sb.append(p);
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public String toString() {
        return "AuthorizationEntry[endpoint=" + this.endpoint + ", roles=" + this.getRoles() + ",type=" + this.type + "]";
    }

    private Set<GroupPrincipal> buildRoles(String roles) {
        HashSet<GroupPrincipal> s = new HashSet<GroupPrincipal>();
        StringTokenizer iter = new StringTokenizer(roles, ",");
        while (iter.hasMoreTokens()) {
            String name = iter.nextToken().trim();
            s.add(new GroupPrincipal(name));
        }
        return s;
    }
}

