/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.core.configuration.access;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.configuration.ConfigurationService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ConfigurationInjector
implements InitializingBean {
    private static final Log LOG = LogFactory.getLog(ConfigurationInjector.class);
    private String id;
    private Map configuration;
    private ConfigurationService configurationService;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map configuration) {
        this.configuration = configuration;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.id);
        Assert.notNull((Object)this.configurationService);
        LOG.info((Object)String.format("Injecting configuration [%s] for the configurationConsumer with id = [%s] ", this.configuration.toString(), this.id));
        this.configurationService.updateConfiguration(this.id, this.configuration);
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

