/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.jaas.config.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.servicemix.kernel.jaas.config.JaasRealm;
import org.apache.servicemix.kernel.jaas.config.impl.Config;
import org.apache.servicemix.kernel.jaas.config.impl.Module;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.osgi.service.exporter.support.OsgiServiceFactoryBean;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ConfigParser
extends AbstractSingleBeanDefinitionParser {
    protected Class getBeanClass(Element element) {
        return Config.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String publish;
        List childElements;
        String name = element.getAttribute("name");
        if (name == null || name.length() == 0) {
            name = element.getAttribute("id");
        }
        builder.addPropertyValue("name", (Object)name);
        String rank = element.getAttribute("rank");
        if (rank != null && rank.length() > 0) {
            builder.addPropertyValue("rank", (Object)Integer.parseInt(rank));
        }
        if ((childElements = DomUtils.getChildElementsByTagName((Element)element, (String)"module")) != null && childElements.size() > 0) {
            ManagedList children = new ManagedList(childElements.size());
            for (int i = 0; i < childElements.size(); ++i) {
                String options;
                Element childElement = (Element)childElements.get(i);
                BeanDefinitionBuilder bd = BeanDefinitionBuilder.genericBeanDefinition(Module.class);
                bd.addPropertyValue("className", (Object)childElement.getAttribute("className"));
                if (childElement.getAttribute("flags") != null) {
                    bd.addPropertyValue("flags", (Object)childElement.getAttribute("flags"));
                }
                if ((options = DomUtils.getTextValue((Element)childElement)) != null && options.length() > 0) {
                    Properties props = new Properties();
                    try {
                        props.load(new ByteArrayInputStream(options.getBytes()));
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Can not load options for JAAS module " + childElement.getAttribute("className") + " in config " + name);
                    }
                    bd.addPropertyValue("options", (Object)props);
                }
                children.add((Object)bd.getBeanDefinition());
            }
            builder.addPropertyValue("modules", (Object)children);
        }
        if (Boolean.valueOf(publish = element.getAttribute("publish")).booleanValue()) {
            BeanDefinitionBuilder bd = BeanDefinitionBuilder.genericBeanDefinition(OsgiServiceFactoryBean.class);
            bd.addPropertyValue("target", (Object)builder.getBeanDefinition());
            bd.addPropertyValue("interfaces", (Object)new Class[]{JaasRealm.class});
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("org.apache.servicemix.kernel.jaas.module", name);
            bd.addPropertyValue("serviceProperties", props);
            AbstractBeanDefinition def = bd.getBeanDefinition();
            String id = parserContext.getReaderContext().generateBeanName((BeanDefinition)def);
            BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)def, id);
            this.registerBeanDefinition(holder, parserContext.getRegistry());
            if (this.shouldFireEvents()) {
                BeanComponentDefinition componentDefinition = new BeanComponentDefinition(holder);
                this.postProcessComponentDefinition(componentDefinition);
                parserContext.registerComponent((ComponentDefinition)componentDefinition);
            }
        }
    }
}

