/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.io.Buffer;
import org.mortbay.io.Buffers;
import org.mortbay.io.Connection;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.IndirectNIOBuffer;
import org.mortbay.io.nio.SelectChannelEndPoint;
import org.mortbay.io.nio.SelectorManager;
import org.mortbay.jetty.AbstractBuffers;
import org.mortbay.jetty.client.Address;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.client.HttpConnection;
import org.mortbay.jetty.client.HttpDestination;
import org.mortbay.jetty.security.SslHttpChannelEndPoint;
import org.mortbay.log.Log;

class SelectConnector
extends AbstractLifeCycle
implements HttpClient.Connector,
Runnable {
    private final HttpClient _httpClient;
    private SSLContext _sslContext;
    private Buffers _sslBuffers;
    SelectorManager _selectorManager = new Manager();

    SelectConnector(HttpClient httpClient) {
        this._httpClient = httpClient;
    }

    protected void doStart() throws Exception {
        this._selectorManager.start();
        this._httpClient._threadPool.dispatch((Runnable)this);
    }

    protected void doStop() throws Exception {
        this._selectorManager.stop();
    }

    public void startConnection(HttpDestination destination) throws IOException {
        SocketChannel channel = SocketChannel.open();
        Address address = destination.isProxied() ? destination.getProxy() : destination.getAddress();
        channel.connect(address.toSocketAddress());
        channel.configureBlocking(false);
        channel.socket().setSoTimeout(this._httpClient.getSoTimeout());
        this._selectorManager.register(channel, (Object)destination);
    }

    public void run() {
        while (this._httpClient.isRunning()) {
            try {
                this._selectorManager.doSelect(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class Manager
    extends SelectorManager {
        Manager() {
        }

        protected SocketChannel acceptChannel(SelectionKey key) throws IOException {
            throw new IllegalStateException();
        }

        public boolean dispatch(Runnable task) {
            return ((SelectConnector)SelectConnector.this)._httpClient._threadPool.dispatch(task);
        }

        protected void endPointOpened(SelectChannelEndPoint endpoint) {
        }

        protected void endPointClosed(SelectChannelEndPoint endpoint) {
        }

        protected Connection newConnection(SocketChannel channel, SelectChannelEndPoint endpoint) {
            return new HttpConnection((Buffers)SelectConnector.this._httpClient, (EndPoint)endpoint, SelectConnector.this._httpClient.getHeaderBufferSize(), SelectConnector.this._httpClient.getRequestBufferSize());
        }

        protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
            HttpDestination dest = (HttpDestination)key.attachment();
            SelectChannelEndPoint ep = null;
            if (dest.isSecure()) {
                if (dest.isProxied()) {
                    String connect = "CONNECT " + dest.getAddress() + "HTTP/1.0" + "\r\n\r\n";
                    throw new IllegalStateException("Not Implemented");
                }
                SSLEngine engine = this.newSslEngine();
                ep = new SslHttpChannelEndPoint(SelectConnector.this._sslBuffers, channel, selectSet, key, engine);
            } else {
                ep = new SelectChannelEndPoint(channel, selectSet, key);
            }
            HttpConnection connection = (HttpConnection)ep.getConnection();
            connection.setDestination(dest);
            dest.onNewConnection(connection);
            return ep;
        }

        private synchronized SSLEngine newSslEngine() throws IOException {
            if (SelectConnector.this._sslContext == null) {
                SelectConnector.this._sslContext = SelectConnector.this._httpClient.getSSLContext();
            }
            SSLEngine sslEngine = SelectConnector.this._sslContext.createSSLEngine();
            sslEngine.setUseClientMode(true);
            sslEngine.beginHandshake();
            if (SelectConnector.this._sslBuffers == null) {
                AbstractBuffers buffers = new AbstractBuffers(){

                    protected Buffer newBuffer(int size) {
                        return new IndirectNIOBuffer(size);
                    }
                };
                buffers.setRequestBufferSize(sslEngine.getSession().getPacketBufferSize());
                buffers.setResponseBufferSize(sslEngine.getSession().getApplicationBufferSize());
                try {
                    buffers.start();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                SelectConnector.this._sslBuffers = (Buffers)buffers;
            }
            return sslEngine;
        }

        protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
            if (attachment instanceof HttpDestination) {
                ((HttpDestination)attachment).onConnectionFailed(ex);
            } else {
                Log.warn((Throwable)ex);
            }
        }
    }
}

