/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.exporter.support;

import org.springframework.core.enums.StaticLabeledEnum;
import org.springframework.osgi.util.internal.ClassUtils;

public abstract class AutoExport
extends StaticLabeledEnum {
    public static final AutoExport DISABLED = new AutoExport(0, "DISABLED"){
        private final Class[] clazz = new Class[0];

        Class[] getExportedClasses(Class targetClass) {
            return this.clazz;
        }
    };
    public static final AutoExport INTERFACES = new AutoExport(1, "INTERFACES"){

        public Class[] getExportedClasses(Class targetClass) {
            return ClassUtils.getClassHierarchy(targetClass, 1);
        }
    };
    public static final AutoExport CLASS_HIERARCHY = new AutoExport(2, "CLASS_HIERARCHY"){

        public Class[] getExportedClasses(Class targetClass) {
            return ClassUtils.getClassHierarchy(targetClass, 2);
        }
    };
    public static final AutoExport ALL_CLASSES = new AutoExport(3, "ALL_CLASSES"){

        public Class[] getExportedClasses(Class targetClass) {
            return ClassUtils.getClassHierarchy(targetClass, 3);
        }
    };

    abstract Class[] getExportedClasses(Class var1);

    private AutoExport(int code, String label) {
        super(code, label);
    }
}

