/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http;

import com.ibm.wsdl.extensions.http.HTTPAddressImpl;
import java.net.URI;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.ExternalEndpoint;
import org.apache.servicemix.common.ManagementSupport;
import org.apache.servicemix.common.security.AuthenticationService;
import org.apache.servicemix.common.security.KeystoreManager;
import org.apache.servicemix.common.tools.wsdl.PortTypeDecorator;
import org.apache.servicemix.http.BasicAuthCredentials;
import org.apache.servicemix.http.HttpComponent;
import org.apache.servicemix.http.HttpEndpointType;
import org.apache.servicemix.http.ProxyParameters;
import org.apache.servicemix.http.SslParameters;
import org.apache.servicemix.http.processors.ConsumerProcessor;
import org.apache.servicemix.http.processors.ProviderProcessor;
import org.apache.servicemix.soap.SoapEndpoint;
import org.apache.servicemix.soap.SoapExchangeProcessor;

public class HttpEndpoint
extends SoapEndpoint
implements HttpEndpointType {
    protected ExtensibilityElement binding;
    protected String locationURI;
    protected SslParameters ssl;
    protected String authMethod;
    protected String soapAction;
    protected BasicAuthCredentials basicAuthentication;
    protected ProxyParameters proxy;
    protected boolean synchronous;
    protected boolean wantContentTypeHeaderFromExchangeIntoHttpRequest;
    protected int timeout;

    public HttpEndpoint() {
    }

    public HttpEndpoint(boolean dynamic) {
        super(dynamic);
    }

    public boolean isWantContentTypeHeaderFromExchangeIntoHttpRequest() {
        return this.wantContentTypeHeaderFromExchangeIntoHttpRequest;
    }

    public void setWantContentTypeHeaderFromExchangeIntoHttpRequest(boolean wantContentTypeHeaderFromExchangeIntoHttpRequest) {
        this.wantContentTypeHeaderFromExchangeIntoHttpRequest = wantContentTypeHeaderFromExchangeIntoHttpRequest;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public SslParameters getSsl() {
        return this.ssl;
    }

    public void setSsl(SslParameters ssl) {
        this.ssl = ssl;
    }

    public ExtensibilityElement getBinding() {
        return this.binding;
    }

    public void setBinding(ExtensibilityElement binding) {
        this.binding = binding;
    }

    public String getLocationURI() {
        return this.locationURI;
    }

    public void setLocationURI(String locationUri) {
        this.locationURI = locationUri;
    }

    public void setBasicAuthentication(BasicAuthCredentials basicAuthCredentials) {
        this.basicAuthentication = basicAuthCredentials;
    }

    public BasicAuthCredentials getBasicAuthentication() {
        return this.basicAuthentication;
    }

    public ProxyParameters getProxy() {
        return this.proxy;
    }

    public void setProxy(ProxyParameters proxy) {
        this.proxy = proxy;
    }

    public void setRoleAsString(String role) {
        super.setRoleAsString(role);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void reloadWsdl() {
        this.description = null;
        this.definition = null;
        this.loadWsdl();
    }

    protected PortType getTargetPortType(Definition def) {
        PortType portType = null;
        if (def.getServices().size() == 0 && def.getPortTypes().size() == 1) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"WSDL only defines a PortType, using this one");
            }
            portType = (PortType)def.getPortTypes().values().iterator().next();
        } else if (this.targetInterfaceName != null) {
            portType = def.getPortType(this.targetInterfaceName);
            if (portType == null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"PortType for targetInterfaceName could not be found");
            }
        } else if (this.targetService != null && this.targetEndpoint != null) {
            Service svc = def.getService(this.targetService);
            Port port = svc != null ? svc.getPort(this.targetEndpoint) : null;
            PortType portType2 = portType = port != null ? port.getBinding().getPortType() : null;
            if (portType == null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"PortType for targetService/targetEndpoint could not be found");
            }
        } else if (this.targetService != null) {
            Service svc = def.getService(this.targetService);
            if (svc != null && svc.getPorts().size() == 1) {
                Port port = (Port)svc.getPorts().values().iterator().next();
                PortType portType3 = portType = port != null ? port.getBinding().getPortType() : null;
            }
            if (portType == null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Service for targetService could not be found");
            }
        } else if (this.interfaceName != null) {
            portType = def.getPortType(this.interfaceName);
            if (portType == null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Service for targetInterfaceName could not be found");
            }
        } else {
            Service svc = def.getService(this.service);
            Port port = svc != null ? svc.getPort(this.endpoint) : null;
            PortType portType4 = portType = port != null && port.getBinding() != null ? port.getBinding().getPortType() : null;
            if (portType == null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Port for service/endpoint could not be found");
            }
        }
        return portType;
    }

    protected void overrideDefinition(Definition def) throws Exception {
        PortType portType = this.getTargetPortType(def);
        if (portType != null) {
            HttpComponent comp;
            int i;
            QName[] names = def.getPortTypes().keySet().toArray(new QName[0]);
            for (i = 0; i < names.length; ++i) {
                if (names[i].equals(portType.getQName())) continue;
                def.removePortType(names[i]);
            }
            names = def.getServices().keySet().toArray(new QName[0]);
            for (i = 0; i < names.length; ++i) {
                def.removeService(names[i]);
            }
            names = def.getBindings().keySet().toArray(new QName[0]);
            for (i = 0; i < names.length; ++i) {
                def.removeBinding(names[i]);
            }
            String location = this.getLocationURI();
            if (!location.endsWith("/")) {
                location = location + "/";
            }
            if ((comp = (HttpComponent)this.getServiceUnit().getComponent()).getConfiguration().isManaged()) {
                String path = new URI(location).getPath();
                location = "http://localhost";
                if (comp.getHost() != null) {
                    location = comp.getProtocol() != null ? comp.getProtocol() + "://" : "http://";
                    location = location + comp.getHost();
                    if (comp.getPort() != 80) {
                        location = location + ":" + comp.getPort();
                    }
                    if (comp.getPath() != null) {
                        location = location + comp.getPath();
                    }
                }
                location = location + comp.getConfiguration().getMapping() + path;
            }
            if (portType.getQName().getNamespaceURI().equals(this.service.getNamespaceURI())) {
                if (this.isSoap()) {
                    PortTypeDecorator.decorate((Definition)def, (PortType)portType, (String)location, (String)(this.endpoint + "Binding"), (String)this.service.getLocalPart(), (String)this.endpoint, (String)this.soapVersion);
                    this.definition = def;
                } else {
                    Binding bnd = def.createBinding();
                    bnd.setPortType(portType);
                    bnd.setQName(new QName(this.service.getNamespaceURI(), this.endpoint + "Binding"));
                    bnd.setUndefined(false);
                    def.addBinding(bnd);
                    Port port = def.createPort();
                    port.setName(this.endpoint);
                    port.setBinding(bnd);
                    HTTPAddressImpl address = new HTTPAddressImpl();
                    address.setLocationURI(location);
                    port.addExtensibilityElement((ExtensibilityElement)address);
                    def.addNamespace("http", "http://schemas.xmlsoap.org/wsdl/http/");
                    Service svc = def.createService();
                    svc.setQName(this.service);
                    svc.addPort(port);
                    def.addService(svc);
                    this.definition = def;
                }
            } else {
                this.definition = PortTypeDecorator.createImportDef((Definition)def, (String)this.service.getNamespaceURI(), (String)"porttypedef.wsdl");
                PortTypeDecorator.decorate((Definition)this.definition, (PortType)portType, (String)location, (String)(this.endpoint + "Binding"), (String)this.service.getLocalPart(), (String)this.endpoint, (String)this.soapVersion);
            }
        }
    }

    protected SoapExchangeProcessor createProviderProcessor() {
        return new ProviderProcessor(this);
    }

    protected SoapExchangeProcessor createConsumerProcessor() {
        return new ConsumerProcessor(this);
    }

    protected ServiceEndpoint createExternalEndpoint() {
        return new ExternalEndpoint(this.getServiceUnit().getComponent().getEPRElementName(), this.getLocationURI(), this.getService(), this.getEndpoint(), this.getInterfaceName());
    }

    public AuthenticationService getAuthenticationService() {
        HttpComponent comp = (HttpComponent)this.getServiceUnit().getComponent();
        return AuthenticationService.Proxy.create((Object)comp.getAuthenticationService());
    }

    public KeystoreManager getKeystoreManager() {
        HttpComponent comp = (HttpComponent)this.getServiceUnit().getComponent();
        return KeystoreManager.Proxy.create((Object)comp.getKeystoreManager());
    }

    public void validate() throws DeploymentException {
        if (this.getRole() == null) {
            throw this.failure("deploy", "Endpoint must have a defined role", null);
        }
        if (this.getLocationURI() == null) {
            throw this.failure("deploy", "Endpoint must have a defined locationURI", null);
        }
        if (!this.isSoap() && this.getRole() == MessageExchange.Role.CONSUMER && this.getDefaultMep() == null) {
            throw this.failure("deploy", "Non soap endpoints must have a defined defaultMep", null);
        }
    }

    protected DeploymentException failure(String task, String info, Throwable e) {
        ManagementSupport.Message msg = new ManagementSupport.Message();
        msg.setComponent(this.serviceUnit.getComponent().getComponentName());
        msg.setTask(task);
        msg.setResult("FAILED");
        msg.setType("ERROR");
        msg.setMessage(info);
        msg.setException(e);
        return new DeploymentException(ManagementSupport.createComponentMessage((ManagementSupport.Message)msg));
    }
}

